<?php
include '../ConsumoApiDemoSis2/Conexion.php';
header("Content-Type: application/json; charset=UTF-8");

class Operaciones
{
    public function PA_OpcionQuitarDetalle_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_OpcionQuitarDetalle_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarProductos_PorDescripcion($buscar1, $buscar2, $buscar3, $buscar4, $buscar5, $buscar6)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar1);
       
        $data = $conn->Procedimiento("PA_ListarArticulosWeb2");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarConceptosI()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", 'Habilitado');
       
        $data = $conn->Procedimiento("PA_ListaConceptos");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarConceptosS()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", 'Habilitado');
       
        $data = $conn->Procedimiento("PA_ListaConceptosS");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function IngresarArticuloWeb($Codigo, $Desc, $Unidad,$Precio)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@ART_Codigo", $Codigo);
        $conn->Parametro("@ART_Descripcion", $Desc);
        $conn->Parametro("@ART_Descripcion2", $Unidad);
        $conn->Parametro("@ART_Precio1", $Precio);
        $data = $conn->Procedimiento("dbo.IngresarArticuloWeb");
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'Serie' => $Codigo];
        return json_encode($data);
	}
	public function PA_InsertarIngreso($Codigo, $Desc,$Precio,$Fecha,$Caja,$Perso)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@ID_CODIGO", $Codigo);
        $conn->Parametro("@ID_FECHA", $Fecha);
        $conn->Parametro("@ID_Monto", $Precio);
        $conn->Parametro("@ID_Concepto", $Desc);
        $conn->Parametro("@PER_CODIGO", $Perso);
        $conn->Parametro("@CD_Codigo", $Caja);
        $data = $conn->Procedimiento("dbo.PA_InsertarIngreso");
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'Serie' => $Codigo];
        return json_encode($data);
	}
	public function PA_InsertarEgreso($Codigo, $Desc,$Precio,$Fecha,$Caja,$Perso,$Desti)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@ID_CODIGO", $Codigo);
        $conn->Parametro("@ID_FECHA", $Fecha);
        $conn->Parametro("@ID_Monto", $Precio);
        $conn->Parametro("@ID_Concepto", $Desc);
        $conn->Parametro("@PER_CODIGO", $Perso);
        $conn->Parametro("@CD_Codigo", $Caja);
        $conn->Parametro("@SAL_Destinatario", $Desti);
        $data = $conn->Procedimiento("dbo.PA_InsertarEgreso");
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'Serie' => $Codigo];
        return json_encode($data);
	}
	public function IngresarConceptoIWeb($Desc)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CON_Descripcion", $Desc);
        
        $data = $conn->Procedimiento("dbo.PA_IngresarConceptoI");
        $data = json_decode(json_encode($data), true);
        $conn->Desconectar();

        $Codigopre = $data[0]['CON_Codigo'];
        $Codigo = str_pad($Codigopre,6,"0",STR_PAD_LEFT); 
        $data = ['rpta'=>'ok', 'Serie' => $Codigo, 'Codigo'=> $Codigopre];
        return json_encode($data);
	}
	public function IngresarConceptoSWeb($Desc)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CON_Descripcion", $Desc);
        
        $data = $conn->Procedimiento("dbo.PA_IngresarConceptoS");
        $data = json_decode(json_encode($data), true);
        $conn->Desconectar();

        $Codigopre = $data[0]['CON_Codigo'];
        $Codigo = str_pad($Codigopre,6,"0",STR_PAD_LEFT); 
        $data = ['rpta'=>'ok', 'Serie' => $Codigo, 'Codigo'=> $Codigopre];
        return json_encode($data);
	}
	public function PA_DocumentosImprimir($codigo, $tipo, $formato)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $conn->Parametro("@Tipo", $tipo);
        $conn->Parametro("@formato", $formato);
        $data = $conn->Procedimiento("dbo.PA_DocumentosImprimir");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ObtenerVenta_PorCodigo_Cabecera($VEN_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_ObtenerVenta_PorCodigo_Cabecera");
        $conn->Desconectar();
        return json_encode($data);
	}
	
		public function PA_ObtenerNArticulo()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("PA_ObtenerNArticulo");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ObtenerNingreso()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("PA_ObtenerNIngreso");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ObtenerNsalida()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("PA_ObtenerNSalida");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_Obtener_notas_electronicasWeb($VEN_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@NC_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_Obtener_notas_electronicasWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
    public function PA_ObtenerVenta_PorCodigo_Detalle($VEN_Codigo)
	{
	    //return '$VEN_Codigo: ' + $VEN_Codigo;
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_ObtenerVenta_PorCodigo_Detalle");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ObtenerDetallesVenta_PorCodigo($VEN_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_ObtenerDetalleVentaWeb_PorCodigo2");
        $conn->Desconectar();
        return json_encode($data);
	}
	    public function PA_ObtenerDetalleNCWeb_PorCodigo($VEN_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_ObtenerDetalleNCWeb_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarArticulosWeb($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulosWeb2");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarVentasWeb_PorTipo($inicio, $final, $codvendedor, $estado, $tipo, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $inicio);
        $conn->Parametro("@Final", $final);
        $conn->Parametro("@CodVendedor", $codvendedor);
        $conn->Parametro("@Estado", $estado);
        $conn->Parametro("@Tipo", $tipo);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarVentasWeb_PorTipo");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ListarVentas2($Inicio, $Final, $Cliente, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@Cliente", $Cliente);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("PA_ListarVentas_Web2");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarCompras($Inicio, $Final, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("PA_ListarNotaIngresoWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_Facturacion($Inicio, $Final, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("PA_ListarFacturacionWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_NotaCredito($Inicio, $Final, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("PA_listar_notas_electronicasWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarPersonalWeb_PorDescripcion($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarPersonalWeb_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarClientesWeb($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarClientesWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_Pedido_JE_ConTransaccion_Eliminar($PED_Codigo, $MES_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@$PED_Codigo", $PED_Codigo);
        $conn->Parametro("@$MES_Codigo", $MES_Codigo);
        $data = $conn->Procedimiento("dbo.PA_Pedido_JE_ConTransaccion_Eliminar");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_VerCambios()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_VerCambios");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarComidas_ConReceta($Descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $Descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarComidas_ConReceta");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ValiarPlatosProgramados($_platosProgramados, $_cantidadProgramados)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@codigos", $_platosProgramados);
        $conn->Parametro("@cantidades", $_cantidadProgramados);
        $data = $conn->Procedimiento("dbo.PA_ValiarPlatosProgramados");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ReporteComidas_PorFechas($inicio, $final, $cat, $panel, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Inicio", $inicio);
        $conn->Parametro("@Fin", $final);
        $conn->Parametro("@Cat", $cat);
        $conn->Parametro("@Panel", $panel);
        $conn->Parametro("@Tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ReporteComidas_PorFechas");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerLogoSistema()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        //$conn->Parametro("@Descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ObtenerLogoSistemaWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ReporteInsumos_AlaFecha($inicio1, $inicio2, $inicio3, $inicio4, $inicio5, $inicio6, $inicio7, $final, $cat, $panel, $Nombre, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio1", $inicio1);
        $conn->Parametro("@Inicio2", $inicio2);
        $conn->Parametro("@Inicio3", $inicio3);
        $conn->Parametro("@Inicio4", $inicio4);
        $conn->Parametro("@Inicio5", $inicio5);
        $conn->Parametro("@Inicio6", $inicio6);
        $conn->Parametro("@Inicio7", $inicio7);
        $conn->Parametro("@Fin", $final);
        $conn->Parametro("@Cat", $cat);
        $conn->Parametro("@Panel", $panel);
        $conn->Parametro("@Nombre", $Nombre);
        $conn->Parametro("@Tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ReporteInsumos_AlaFecha");
        $conn->Desconectar();
        return json_encode($data);
	}
	
    public function PA_ObtenerPersonal_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPersonal_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulos_Programacion_PorDescripcion($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulos_Programacion_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data);
	}
    
	public function PA_ListarPedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarPedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarDetallesDePedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarDetallesDePedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_GeneraCodigoPedido()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_GeneraCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_Ventas_WEB($pedido){
	    try{
	        $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $pedido['Codigo']);
            $conn->Parametro("@Fecha", '');
            $conn->Parametro("@Hora", '');
            $conn->Parametro("@TipoVenta", $pedido['TipoDocumento']);
            $conn->Parametro("@Serie", '');
            $conn->Parametro("@SubTotal", 0);
            $conn->Parametro("@IGV", 0);
            $conn->Parametro("@Total", $pedido['Total']);
            $conn->Parametro("@Interez", '');
            $conn->Parametro("@Estado", 'Habilitada');
            $conn->Parametro("@EstadoCuenta", 'PENDIENTE');
            $conn->Parametro("@CodPersonal", $pedido['PER_Codigo']);
            $conn->Parametro("@CodCliente", $pedido['CodCliente']);
            $conn->Parametro("@CodigoVenta", '');
            $conn->Parametro("@TipoVenta2", 'CONTADO');
            $conn->Parametro("@NroPedido", '');
            $conn->Parametro("@FechaAtencion", '');
            $conn->Parametro("@HoraAtencion", '');
            $conn->Parametro("@Responsable", '');
            $conn->Parametro("@Glosa",'');
            $conn->Parametro("@Otros1", '');
            $conn->Parametro("@Otros2", '');
            $conn->Parametro("@CodigoCaja", '');
            $conn->Parametro("@FechaVencimiento", '');
            $conn->Parametro("@Sucursal", '');
            $conn->Parametro("@Encargado", $pedido['Observaciones']);
            $conn->Parametro("@Otros3", 'WEB');
            $conn->Parametro("@Otros4", $pedido['Origen']);
            $conn->Parametro("@Exonerado", 0);
            $conn->Parametro("@Tipo", $pedido['TipoAccion']);
            $data = $conn->Procedimiento("dbo.PA_Ventas_WEB");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Codigo = $data[0]['Codigo'];
            $Serie = $data[0]['Serie'];
            
            $detalles = (array) $pedido['DetallePedido'];
            
            $conn = new Conexion();
            $conn->Conectar();
            $data = [];
            for($i=0; $i<count($detalles); $i++){
                $dd = $detalles[$i];
                $conn->reiniciarArray();
                $conn->Parametro("@Codigo", $Codigo);
                $conn->Parametro("@Unidad", $dd['unidad']);
                $conn->Parametro("@Cantidad", $dd['cantidad']);
                $conn->Parametro("@Precio", $dd['venta']);
                $conn->Parametro("@SubTotal", $dd['importe']);
                $conn->Parametro("@CodigoArt", $dd['codigo']);
                $conn->Parametro("@CantidadString", $dd['cantidad']);
                $conn->Parametro("@Contenido", $dd['contenido']);
                $conn->Parametro("@TipoVenta", 'LIBRE');
                $conn->Parametro("@CantidadStock", 0);
                $conn->Parametro("@DescuentoPorcentaje", 0);
                $conn->Parametro("@DescuentoSoles", 0);
                $conn->Parametro("@Costo", $dd['costo']);
                $conn->Parametro("@Exonerado", $dd['exonerado']);
                $data = $conn->Procedimiento("dbo.PA_DetalleVentas");   
            }
            $conn->Desconectar();
            
            $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@Tipo", $pedido['TipoDocumento']);
            $conn->Parametro("@VEN_Codigo", $Codigo);
            $data = $conn->Procedimiento("dbo.PA_ActualizarVenta_Web");  
            $conn->Desconectar();
             
            $data = ['rpta'=>'ok', 'Serie' => $Codigo];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['rpta'=>'error'.$ex->getMessage()];
            return json_encode($data);
	    }
	}
	
	public function PA_Ventas_WEB2($pedido){
	    try{
	        $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $pedido['Codigo']);
            $conn->Parametro("@Fecha", '');
            $conn->Parametro("@Hora", '');
            $conn->Parametro("@TipoVenta", $pedido['TipoDocumento']);
            $conn->Parametro("@Serie", '');
            $conn->Parametro("@SubTotal", 0);
            $conn->Parametro("@IGV", 0);
            $conn->Parametro("@Total", $pedido['Total']);
            $conn->Parametro("@Interez", '');
            $conn->Parametro("@Estado", 'Habilitada');
            $conn->Parametro("@EstadoCuenta", 'PENDIENTE');
            $conn->Parametro("@CodPersonal", $pedido['PER_Codigo']);
            $conn->Parametro("@CodCliente", $pedido['CodCliente']);
            $conn->Parametro("@CodigoVenta", '');
            $conn->Parametro("@TipoVenta2", $pedido['Condicion']);
            $conn->Parametro("@NroPedido", $pedido['FP_Codigo']);
            $conn->Parametro("@FechaAtencion", '');
            $conn->Parametro("@HoraAtencion", '');
            $conn->Parametro("@Responsable", '');
            $conn->Parametro("@Glosa", $pedido['Glosa']);
            $conn->Parametro("@Otros1", '');
            $conn->Parametro("@Otros2", '');
            $conn->Parametro("@CodigoCaja", '');
            $conn->Parametro("@FechaVencimiento", '');
            $conn->Parametro("@Sucursal", '');
            $conn->Parametro("@Encargado", $pedido['Observaciones']);
            $conn->Parametro("@Otros3", 'WEB');
            $conn->Parametro("@Otros4", $pedido['Origen']);
            $conn->Parametro("@Exonerado", 0);
            $conn->Parametro("@VEN_NroOperacion", $pedido['NroOperacion']);
            $conn->Parametro("@VEN_Efectivo", $pedido['Efectivo']);
            $conn->Parametro("@VEN_Tarjeta", $pedido['Tarjeta']);
            $conn->Parametro("@DiasCredito", $pedido['DiasCredito']);
            $conn->Parametro("@SumaCaja", $pedido['SumaCaja']);
            $conn->Parametro("@Tipo", $pedido['TipoAccion']);
            $data = $conn->Procedimiento("dbo.PA_Ventas_WEB2");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Codigo = $data[0]['Codigo'];
            $Serie = $data[0]['Serie'];
            
            $detalles = (array) $pedido['DetallePedido'];
            
            $conn = new Conexion();
            $conn->Conectar();
            $data = [];
            for($i=0; $i<count($detalles); $i++){
                $dd = $detalles[$i];
                $conn->reiniciarArray();
                $conn->Parametro("@Codigo", $Codigo);
                $conn->Parametro("@Unidad", $dd['unidad']);
                $conn->Parametro("@Cantidad", $dd['cantidad']);
                $conn->Parametro("@Precio", $dd['venta']);
                $conn->Parametro("@SubTotal", $dd['importe']);
                $conn->Parametro("@CodigoArt", $dd['codigo']);
                $conn->Parametro("@CantidadString", $dd['cantidad']);
                $conn->Parametro("@Contenido", $dd['contenido']);
                $conn->Parametro("@TipoVenta", 'LIBRE');
                $conn->Parametro("@CantidadStock", 0);
                $conn->Parametro("@DescuentoPorcentaje", 0);
                $conn->Parametro("@DescuentoSoles", 0);
                $conn->Parametro("@Costo", $dd['costo']);
                $conn->Parametro("@Exonerado", $dd['exonerado']);
                $data = $conn->Procedimiento("dbo.PA_DetalleVentas");   
            }
            $conn->Desconectar();
            
            $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@Tipo",'ATENDIDO');
            $conn->Parametro("@VEN_Codigo", $Codigo);
            $data = $conn->Procedimiento("dbo.PA_ActualizarVenta_Web");  
            $conn->Desconectar();
             
            $data = ['rpta'=>'ok', 'Serie' => $Codigo, 'NroGenerado' => $Serie];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['rpta'=>'error'.$ex->getMessage()];
            return json_encode($data);
	    }
	}
	
	public function PA_ClienteWeb($cliente){
	    try{
	        $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@documento", $cliente['documento']);
            $conn->Parametro("@cliente", $cliente['cliente']);
            $conn->Parametro("@direccion", $cliente['direccion']);
            $data = $conn->Procedimiento("dbo.PA_ClienteWeb");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Codigo = $data[0]['CodigoGenerado'];
            $Existe = $data[0]['Existe'];
             
            $data = ['CodigoGenerado' => $Codigo, 'Existe' => $Existe];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['CodigoGenerado' => '000000', 'Existe' => 'NO'];
            return json_encode($data);
	    }
	}
	
	public function PA_MODIFICAR_PEDIDO($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $pedido['Codigo']);
        $conn->Parametro("@CodCliente", $pedido['CodCliente']);
        $conn->Parametro("@CodMesa", $pedido['CodMesa']);
        $conn->Parametro("@NroPersonas", $pedido['NroPersonas']);
        $conn->Parametro("@Cliente", $pedido['Cliente']);
        $conn->Parametro("@Mesero", $pedido['Mesero']);
        $conn->Parametro("@Observaciones", $pedido['Observaciones']);
        $conn->Parametro("@TipoDocumento", $pedido['TipoDocumento']);
        $conn->Parametro("@Serie", $pedido['Serie']);
        $conn->Parametro("@Correlativo", $pedido['Correlativo']);
        $conn->Parametro("@SubTotal", $pedido['SubTotal']);
        $conn->Parametro("@IGV", $pedido['IGV']);
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@TipoPago", $pedido['TipoPago']);
        $conn->Parametro("@EstadoCuenta", $pedido['EstadoCuenta']);
        $conn->Parametro("@Estado", $pedido['Estado']);
        $conn->Parametro("@CodigoOperacionTarjeta", $pedido['CodigoOperacionTarjeta']);
        $conn->Parametro("@MontoOperacionTarjeta", $pedido['MontoOperacionTarjeta']);
        $conn->Parametro("@Impreso", $pedido['Impreso']);
        $conn->Parametro("@Dispositivo", $pedido['Dispositivo']);
        $conn->Parametro("@Forma", $pedido['Forma']);
        $conn->Parametro("@DetallePedido", $pedido['DetallePedido']);
        $conn->Parametro("@FDM_Codigo", $pedido['FDM_Codigo']);
        $conn->Parametro("@ClienteJE", $pedido['ClienteJE']);
        $conn->Parametro("@CelularJE", $pedido['CelularJE']);
        $data = $conn->Procedimiento("dbo.PA_MODIFICAR_PEDIDO");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_EliminarTablaTemporal_PorCodigoPedido($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_EliminarTablaTemporal_PorCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarTablaTemporal($detalles)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = [];
        for($i=0; $i<count($detalles); $i++){
            $dd = $detalles[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $dd['Codigo']);
            $conn->Parametro("@CodigoProducto", $dd['CodigoProducto']);
            $conn->Parametro("@Cantidad", $dd['Cantidad']);
            $conn->Parametro("@Descripcion", $dd['Descripcion']);
            $conn->Parametro("@Accion", $dd['Accion']);
            $conn->Parametro("@Precio", $dd['Precio']);
            $data = $conn->Procedimiento("dbo.PA_InsertarTablaTemporal");   
        }
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_ListarMesasxUbicacion($ubicacion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Ubicacion", $ubicacion);
        $data = $conn->Procedimiento("dbo.PA_ListarMesasxUbicacion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPersonalVer()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarPersonalVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCajaVer($sucursal)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@sucursal", $sucursal);
        $data = $conn->Procedimiento("dbo.PA_ListarCajaVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function ActualizaImpresionPedido($id, $valor)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $conn->Parametro("@Valor", 'NO');
        $data = $conn->Procedimiento("dbo.PA_ActualizaEstadoPedidoImpresion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $conn->Parametro("@cliente", $cliente);
        $conn->Parametro("@observaciones", $observaciones);
        $data = $conn->Procedimiento("dbo.PA_SOLO_CLIENTE");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarZonasMesa($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarZonasMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCategorias_PorAbreviatura($abrevitura)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@abreviatura", $abrevitura);
        $data = $conn->Procedimiento("dbo.PA_ListarCategorias_PorAbreviatura");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCategorias()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarCategorias");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulosxCategoria_Programacion($categoria)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Categoria", $categoria);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulosxCategoria_Programacion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPermisosWeb_PorUsuario($codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarPermisosWeb_PorUsuario");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerEstadoSeEstaCobrando_PorCodigo($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerEstadoSeEstaCobrando_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_EstadoCaja_xCodigo_WEB($CD_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CD_Codigo", $CD_Codigo);
        $data = $conn->Procedimiento("dbo.PA_EstadoCaja_xCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarIngresosDineroEntreFechasXCaja($Inicio, $Final, $Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarIngresoDinero");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarIngresosDineroWEB($Inicio, $Final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $data = $conn->Procedimiento("dbo.PA_ListarIngresoDineroWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarSalidasDineroEntreFechasxCaja($Inicio, $Final, $Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinak", $Final);
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarSalidasDineroEntreFechasxCaja");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ListarEgresosDineroWEB($Inicio, $Final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $data = $conn->Procedimiento("dbo.PA_ListarEgresoDineroWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarVentas_WEB($Inicio, $Final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $data = $conn->Procedimiento("dbo.PA_ListarVentas_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulos_PorTipo($Tipo, $Descripcion, $Categoria)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Tipo", $Tipo);
        $conn->Parametro("@Descripcion", $Descripcion);
        $conn->Parametro("@Categoria", $Categoria);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulos_PorTipo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarInsumos_WEB($descripcion, $categoria, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $descripcion);
        $conn->Parametro("@cat", $categoria);
        $conn->Parametro("@tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ListarInsumos_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCategorias_PorTipoWEB($Tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Tipo", $Tipo);
        $data = $conn->Procedimiento("dbo.PA_ListarCategorias_PorTipoWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarBebidasStockMinimo()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", "Habilitado");
        $data = $conn->Procedimiento("dbo.PA_ListarBebidasStockMinimo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarInsumosStockMinimo()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", "Habilitado");
        $data = $conn->Procedimiento("dbo.PA_ListarInsumosStockMinimo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCajasxFecha($inicio, $final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@fechaInicio", $inicio);
        $conn->Parametro("@fechaFinal", $final);
        $data = $conn->Procedimiento("dbo.PA_ListarCajasxFecha");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_BuscarFormulario_PorCliente_WEB($FDM_NombreCliente, $FDM_Tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FDM_NombreCliente", $FDM_NombreCliente);
        $conn->Parametro("@FDM_Tipo", $FDM_Tipo);
        $data = $conn->Procedimiento("dbo.PA_BuscarFormulario_PorCliente_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerPedido_PorCodigo_WEB($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPedido_PorCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerIngreso_PorCodigo($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@VEN_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerIngreso_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ObtenerDetalleVentaWeb_PorCodigo($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@VEN_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerDetalleVentaWeb_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerDetallePedido_PorCodigo_WEB($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerDetallePedido_PorCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerFormularioDeliveryMostrador_PorCodigo($FDM_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@FDM_Codigo", $FDM_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerFormularioDeliveryMostrador_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarFormularioDeliveryMostrador($obj){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@FDM_Codigo", $obj['FDM_Codigo']);
        $conn->Parametro("@FDM_Tipo", $obj['FDM_Tipo']);
        $conn->Parametro("@FDM_Estado", $obj['FDM_Estado']);
        $conn->Parametro("@FDM_NombreCliente", $obj['FDM_NombreCliente']);
        $conn->Parametro("@FDM_Celular", $obj['FDM_Celular']);
        $data = $conn->Procedimiento("dbo.PA_InsertarFormularioDeliveryMostrador");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'datos'=>$data];
        return json_encode($data);
	}
	
	public function PA_ListarCajaxCodigo($Codigo){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarCajaxCodigo");  
        
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_CajaDinero_WEB($SaldoInicial, $CodigoPersonal, $Almacen, $Tipo, $xCD, $Ingresos, $Egresos, $SaldoActual, $Retiro, $SaldoFinal){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@SaldoInicial", $SaldoInicial);
        $conn->Parametro("@CodigoPersonal", $CodigoPersonal);
        $conn->Parametro("@Almacen", $Almacen);
        $conn->Parametro("@Tipo", $Tipo);
        $conn->Parametro("@xCD", $xCD);
        $conn->Parametro("@Ingresos", $Ingresos);
        $conn->Parametro("@Egresos", $Egresos);
        $conn->Parametro("@SaldoActual", $SaldoActual);
        $conn->Parametro("@Retiro", $Retiro);
        $conn->Parametro("@SaldoFinal", $SaldoFinal);
        $data = $conn->Procedimiento("dbo.PA_CajaDinero_WEB");  
        
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB1($CodigoCaja){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@CD_Codigo", $CodigoCaja);
        $data = $conn->Procedimiento("dbo.PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB1");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB2($CodigoCaja){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@CD_Codigo", $CodigoCaja);
        $data = $conn->Procedimiento("dbo.PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB2");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarFormaPago(){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ListarFormaPago");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_IngresoDinero_WEB($Obj){
        try{
            $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@ID_Codigo", $Obj['Codigo']);
            $conn->Parametro("@ID_Fecha", $Obj['Fecha']);
            $conn->Parametro("@ID_Monto", $Obj['Importe']);
            $conn->Parametro("@ID_Concepto", $Obj['Observacion']);
            $conn->Parametro("@CON_Codigo", $Obj['idconcepto']);
            $conn->Parametro("@PER_Codigo", $Obj['PER_Codigo']);
            $conn->Parametro("@Tipo", $Obj['Tipo']);
            $data = $conn->Procedimiento("dbo.PA_IngresoDinero_WEB");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Rpta = $data[0]['Rpta'];
            $Codigo = $data[0]['CodigoGenerado'];
            
            $data = ['Rpta' => $Rpta, 'CodigoGenerado' => $Codigo];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['Rpta'=>'error'.$ex->getMessage()];
            return json_encode($data);
	    }
	}
	
	public function PA_ObtenerIngresoDinero_WEB($id){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@ID_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerIngresoDinero_WEB");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerSalidaDinero_WEB($id){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@SAL_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerSalidaDinero_WEB");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_SalidaDinero_WEB($Obj){
        try{
            $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@SAL_Codigo", $Obj['Codigo']);
            $conn->Parametro("@SAL_Fecha", $Obj['Fecha']);
            $conn->Parametro("@SAL_Destinatario", $Obj['Se単or']);
            $conn->Parametro("@SAL_Monto", $Obj['Importe']);
            $conn->Parametro("@SAL_Concepto", $Obj['Observacion']);
            $conn->Parametro("@CON_Codigo", $Obj['idconcepto']);
            $conn->Parametro("@PER_Codigo", $Obj['PER_Codigo']);
            $conn->Parametro("@Tipo", $Obj['Tipo']);
            $data = $conn->Procedimiento("dbo.PA_SalidaDinero_WEB");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Rpta = $data[0]['Rpta'];
            $Codigo = $data[0]['CodigoGenerado'];
            
            $data = ['Rpta' => $Rpta, 'CodigoGenerado' => $Codigo];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['Rpta'=>'error'.$ex->getMessage()];
            return json_encode($data);
	    }
	}
	
	
	
	public function PA_ObtenerVenta_PorCodigo($VEN_Codigo){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerVenta_PorCodigo");  
        $conn->Desconectar();
        
        $datatable1 = $data;
        
        
        $conn->Conectar();
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ObtenerLogoEmpresa");  
        $conn->Desconectar();
        
        $datatable2 = $data;
        
        $DataSet = [
            'datatable1' => $datatable1,
            'datatable2' => $datatable2
        ];
        
        return json_encode($DataSet);
	}
	
	public function PA_ObtenerLogoEmpresa(){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ObtenerLogoEmpresa");  
        $conn->Desconectar();
        
        $datatable2 = $data;
        return json_encode($data);
	}
	
	
	
	
}

$request = json_decode(file_get_contents('php://input'), true);

switch ($request['accion']) {
	case 'PA_Ventas_WEB':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_Ventas_WEB($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_Ventas_WEB2':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_Ventas_WEB2($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	    case 'PA_ObtenerVenta_PorCodigo_Detalle':
		try{
		    $VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerVenta_PorCodigo_Detalle($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ClienteWeb':
	    try{
		    $pedido = $request['cliente'];
        	$app = new Operaciones();
        	echo $app->PA_ClienteWeb($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_MODIFICAR_PEDIDO':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_MODIFICAR_PEDIDO($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_ListarProductos_PorDescripcion':
		try{
        	$buscar1 = $request['buscar1'];
        	
        	$app = new Operaciones();
        	echo $app->PA_ListarProductos_PorDescripcion($buscar1, $buscar2, $buscar3, $buscar4, $buscar5, $buscar6);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarConceptosI':
		try{
        
        	$app = new Operaciones();
        	echo $app->PA_ListarConceptosI();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ListarConceptosS':
		try{
        	
        	
        	$app = new Operaciones();
        	echo $app->PA_ListarConceptosS();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;        
    case 'PA_ObtenerPersonal_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerPersonal_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_OpcionQuitarDetalle_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_OpcionQuitarDetalle_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_DocumentosImprimir':
		try{
        	$codigo = $request['codigo'];
        	$tipo = $request['tipo'];
        	$formato = $request['formato'];
        	$app = new Operaciones();
        	echo $app->PA_DocumentosImprimir($codigo, $tipo, $formato);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'IngresarArticuloWeb':
		try{
        	$codigo = $request['Codigo'];
        	$Desc = $request['Desc'];
        	$Unidad = $request['Unidad'];
        	$Precio = $request['Precio'];
        	$app = new Operaciones();
        	echo $app->IngresarArticuloWeb($codigo, $Desc, $Unidad,$Precio);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarIngreso':
		try{
        	$Codigo = $request['Codigo'];
        	$Desc = $request['Desc'];
        	$Caja = $request['Caja'];
        	$Precio = $request['Precio'];
        	$Fecha = $request['Fecha'];
        	$Perso = $request['Personal'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarIngreso($Codigo, $Desc,$Precio,$Fecha,$Caja,$Perso);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarEgreso':
		try{
        	$Codigo = $request['Codigo'];
        	$Desc = $request['Desc'];
        	$Caja = $request['Caja'];
        	$Precio = $request['Precio'];
        	$Fecha = $request['Fecha'];
        	$Perso = $request['Personal'];
        	$Desti = $request['Dest'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarEgreso($Codigo, $Desc,$Precio,$Fecha,$Caja,$Perso,$Desti);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'IngresarConceptoIWeb':
		try{
        	$Desc = $request['Desc'];
        	$app = new Operaciones();
        	echo $app->IngresarConceptoIWeb($Desc);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;  
	case 'IngresarConceptoSWeb':
		try{
        	$Desc = $request['Desc'];
        	$app = new Operaciones();
        	echo $app->IngresarConceptoSWeb($Desc);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ObtenerDetallesVenta_PorCodigo':
		try{
        	$VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetallesVenta_PorCodigo($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerDetalleNCWeb_PorCodigo':
		try{
        	$VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetalleNCWeb_PorCodigo($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ObtenerVenta_PorCodigo_Cabecera':
		try{
		    $VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerVenta_PorCodigo_Cabecera($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerNArticulo':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerNArticulo();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerNingreso':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerNingreso();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerNsalida':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerNsalida();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_Obtener_notas_electronicasWeb':
		try{
		    $VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_Obtener_notas_electronicasWeb($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulosWeb':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulosWeb($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarVentasWeb_PorTipo':
		try{
        	$inicio = $request['Inicio'];
        	$final = $request['Final'];
        	$codvendedor = $request['CodVendedor'];
        	$estado = $request['Estado'];
        	$tipo = $request['Tipo'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarVentasWeb_PorTipo($inicio, $final, $codvendedor, $estado, $tipo,$buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarVentas2':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
        	$Cliente = $request['Cliente'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarVentas2($Inicio, $Final, $Cliente, $buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarCompras':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCompras($Inicio, $Final, $buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_Facturacion':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_Facturacion($Inicio, $Final, $buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_NotaCredito':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_NotaCredito($Inicio, $Final, $buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ListarPersonalWeb_PorDescripcion':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonalWeb_PorDescripcion($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarClientesWeb':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarClientesWeb($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_Pedido_JE_ConTransaccion_Eliminar':
		try{
        	$PED_Codigo = $request['PED_Codigo'];
        	$MES_Codigo = $request['MES_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_Pedido_JE_ConTransaccion_Eliminar($PED_Codigo, $MES_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_VerCambios':
		try{
        	$app = new Operaciones();
        	echo $app->PA_VerCambios($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarComidas_ConReceta':
		try{
        	$Descripcion = $request['Descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarComidas_ConReceta($Descripcion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ValiarPlatosProgramados':
		try{
        	$_platosProgramados = $request['_platosProgramados'];
        	$_cantidadProgramados = $request['_cantidadProgramados'];
        	$app = new Operaciones();
        	echo $app->PA_ValiarPlatosProgramados($_platosProgramados, $_cantidadProgramados);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ReporteComidas_PorFechas':
		try{
        	$Inicio = $request['Inicio'];
        	$Fin = $request['Fin'];
        	$Cat = $request['Cat'];
        	$Panel = $request['Panel'];
        	$Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ReporteComidas_PorFechas($Inicio, $Fin, $Cat, $Panel, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ReporteInsumos_AlaFecha':
		try{
        	$Inicio1 = $request['Inicio1'];
        	$Inicio2 = $request['Inicio2'];
        	$Inicio3 = $request['Inicio3'];
        	$Inicio4 = $request['Inicio4'];
        	$Inicio5 = $request['Inicio5'];
        	$Inicio6 = $request['Inicio6'];
        	$Inicio7 = $request['Inicio7'];
        	$Fin = $request['Fin'];
        	$Cat = $request['Cat'];
        	$Panel = $request['Panel'];
        	$Nombre = $request['Nombre'];
        	$Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ReporteInsumos_AlaFecha($Inicio1, $Inicio2, $Inicio3, $Inicio4, $Inicio5, $Inicio6, $Inicio7, $Fin, $Cat, $Panel, $Nombre, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulos_Programacion_PorDescripcion':
		try{
        	$id = $request['descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulos_Programacion_PorDescripcion($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarPedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarDetallesDePedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarDetallesDePedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_GeneraCodigoPedido':
		try{
        	$app = new Operaciones();
        	echo $app->PA_GeneraCodigoPedido();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_EliminarTablaTemporal_PorCodigoPedido':
		try{
		    $id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_EliminarTablaTemporal_PorCodigoPedido($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarTablaTemporal':
		try{
		    $detalles = $request['detalles'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarTablaTemporal($detalles);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarMesasxUbicacion':
		try{
		    $ubicacion = $request['ubicacion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarMesasxUbicacion($ubicacion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPersonalVer':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonalVer();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajaVer':
		try{
		    $sucursal = $request['sucursal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCajaVer($sucursal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'ActualizaImpresionPedido':
		try{
		    $id = $request['codigo'];
		    $valor = $request['valor'];
        	$app = new Operaciones();
        	echo $app->ActualizaImpresionPedido($id, $valor);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_SOLO_CLIENTE':
		try{
		    $PED_Codigo = $request['PED_Codigo'];
		    $cliente = $request['cliente'];
		    $observaciones = $request['observaciones'];
        	$app = new Operaciones();
        	echo $app->PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarZonasMesa':
		try{
		    $descripcion = $request['Descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarZonasMesa($descripcion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	
	case 'PA_ListarCategorias_PorAbreviatura':
		try{
		    $abreviatura = $request['abreviatura'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCategorias_PorAbreviatura($abreviatura);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarCategorias':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarCategorias();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulosxCategoria_Programacion':
		try{
		    $categoria = $request['Categoria'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulosxCategoria_Programacion($categoria);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPermisosWeb_PorUsuario':
		try{
		    $id = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPermisosWeb_PorUsuario($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerEstadoSeEstaCobrando_PorCodigo':
		try{
		    $PER_Codigo = $request['PER_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerEstadoSeEstaCobrando_PorCodigo($PER_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_EstadoCaja_xCodigo_WEB':
	    try{
		    $CD_Codigo = $request['CD_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_EstadoCaja_xCodigo_WEB($CD_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarIngresosDineroEntreFechasXCaja':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarIngresosDineroEntreFechasXCaja($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarIngresosDineroWEB':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarIngresosDineroWEB($FechaInicio, $FechaFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
		case 'PA_ListarEgresosDineroWEB':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarEgresosDineroWEB($FechaInicio, $FechaFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;     
    case 'PA_ListarSalidasDineroEntreFechasxCaja':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarSalidasDineroEntreFechasxCaja($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarVentas_WEB':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarVentas_WEB($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulos_PorTipo':
	    try{
		    $Tipo = $request['Tipo'];
		    $Descripcion = $request['Descripcion'];
		    $Categoria = $request['Categoria'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulos_PorTipo($Tipo, $Descripcion, $Categoria);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarInsumos_WEB':
	    try{
		    $Descripcion = $request['descrip'];
		    $Categoria = $request['cat'];
		    $Tipo = $request['tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarInsumos_WEB($Descripcion, $Categoria, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarCategorias_PorTipoWEB':
	    try{
		    $Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCategorias_PorTipoWEB($Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarBebidasStockMinimo':
	    try{
        	$app = new Operaciones();
        	echo $app->PA_ListarBebidasStockMinimo();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarInsumosStockMinimo':
	    try{
        	$app = new Operaciones();
        	echo $app->PA_ListarInsumosStockMinimo();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajasxFecha':
	    try{
	        $fechaInicio = $request['fechaInicio'];
	        $fechaFinal = $request['fechaFinal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCajasxFecha($fechaInicio, $fechaFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_BuscarFormulario_PorCliente_WEB':
	    try{
	        $FDM_NombreCliente = $request['FDM_NombreCliente'];
	        $FDM_Tipo = $request['FDM_Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_BuscarFormulario_PorCliente_WEB($FDM_NombreCliente, $FDM_Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerPedido_PorCodigo_WEB':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerPedido_PorCodigo_WEB($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerIngreso_PorCodigo':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerIngreso_PorCodigo($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ObtenerDetalleVentaWeb_PorCodigo':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetalleVentaWeb_PorCodigo($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerDetallePedido_PorCodigo_WEB':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetallePedido_PorCodigo_WEB($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerFormularioDeliveryMostrador_PorCodigo':
	    try{
	        $FDM_Codigo = $request['FDM_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerFormularioDeliveryMostrador_PorCodigo($FDM_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarFormularioDeliveryMostrador':
	    try{
	        $obj = $request['obj'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarFormularioDeliveryMostrador($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerLogoSistema':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerLogoSistema();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajaxCodigo':
		try{
        	$app = new Operaciones();
        	$Codigo = $request['Codigo'];
        	echo $app->PA_ListarCajaxCodigo($Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_CajaDinero_WEB':
		try{
        	$app = new Operaciones();
        	$SaldoInicial = $request['SaldoInicial'];
        	$CodigoPersonal = $request['CodigoPersonal'];
        	$Almacen = $request['Almacen'];
        	$Tipo = $request['Tipo'];
        	
        	$xCD = $request['xCD'];
        	$Ingresos = $request['Ingresos'];
        	$Egresos = $request['Egresos'];
        	$SaldoActual = $request['SaldoActual'];
        	$Retiro = $request['Retiro'];
        	$SaldoFinal = $request['SaldoFinal'];
        	echo $app->PA_CajaDinero_WEB($SaldoInicial, $CodigoPersonal, $Almacen, $Tipo, $xCD, $Ingresos, $Egresos, $SaldoActual, $Retiro, $SaldoFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB1':
		try{
        	$app = new Operaciones();
        	$CodigoCaja = $request['Codigo'];
        	echo $app->PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB1($CodigoCaja);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB2':
		try{
        	$app = new Operaciones();
        	$CodigoCaja = $request['Codigo'];
        	echo $app->PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB2($CodigoCaja);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarFormaPago':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarFormaPago();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_IngresoDinero_WEB':
		try{
        	$app = new Operaciones();
        	$Obj = $request['Obj'];
        	echo $app->PA_IngresoDinero_WEB($Obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ObtenerIngresoDinero_WEB':
		try{
        	$app = new Operaciones();
        	$id = $request['id'];
        	echo $app->PA_ObtenerIngresoDinero_WEB($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ObtenerSalidaDinero_WEB':
		try{
        	$app = new Operaciones();
        	$id = $request['id'];
        	echo $app->PA_ObtenerSalidaDinero_WEB($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_SalidaDinero_WEB':
		try{
        	$app = new Operaciones();
        	$Obj = $request['Obj'];
        	echo $app->PA_SalidaDinero_WEB($Obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ObtenerVenta_PorCodigo':
		try{
        	$app = new Operaciones();
        	$VEN_Codigo = $request['VEN_Codigo'];
        	echo $app->PA_ObtenerVenta_PorCodigo($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ObtenerLogoEmpresa':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerLogoEmpresa();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
}






