<?php
include '../ConsumoApiPedidoParme/Conexion.php';
header("Content-Type: application/json; charset=UTF-8");

class Operaciones
{
    public function PA_OpcionQuitarDetalle_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_OpcionQuitarDetalle_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulosWeb($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulosWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerDetalleVentaWeb_PorCodigo($codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerDetalleVentaWeb_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_DocumentosImprimir($codigo, $tipo, $formato)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $conn->Parametro("@Tipo", $tipo);
        $conn->Parametro("@Formato", $formato);
        $data = $conn->Procedimiento("dbo.PA_DocumentosImprimir");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPersonalWeb_PorDescripcion($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarPersonalWeb_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarVentasWeb_PorTipo($Inicio, $Final, $CodVendedor, $Estado, $Tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@CodVendedor", $CodVendedor);
        $conn->Parametro("@Estado", $Estado);
        $conn->Parametro("@Tipo", $Tipo);
        $data = $conn->Procedimiento("dbo.PA_ListarVentasWeb_PorTipo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarClientesWeb($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarClientesWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	
    public function PA_ObtenerPersonal_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPersonal_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulos_Programacion_PorDescripcion($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulos_Programacion_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data);
	}
    
	public function PA_ListarPedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarPedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarDetallesDePedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarDetallesDePedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_GeneraCodigoPedido()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_GeneraCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ClienteWeb($cliente){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@documento", $cliente['documento']);
        $conn->Parametro("@cliente", $cliente['cliente']);
        $conn->Parametro("@direccion", $cliente['direccion']);
        
        $data = $conn->Procedimiento("dbo.PA_ClienteWeb");  
        $data = json_decode(json_encode($data), true);
        $conn->Desconectar();
        
        $codigoGenerado = $data[0]['CodigoGenerado'];
        $existe = $data[0]['Existe'];
        
        $data = ['rpta'=>'ok', 'CodigoGenerado'=>$codigoGenerado, 'Existe'=>$existe];
        return json_encode($data);
	}
	
	public function PA_REGISTRAR_COTIZACION($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $pedido['Codigo']);
        $conn->Parametro("@Fecha", '19971231');
        $conn->Parametro("@Hora", '19971231');
        $conn->Parametro("@TipoVenta", 'COTIZACION');
        $conn->Parametro("@Serie", '');
        $conn->Parametro("@SubTotal", '0');
        $conn->Parametro("@IGV", '0');
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@Interez", 'NO');
        $conn->Parametro("@Estado", 'Habilitada');
        $conn->Parametro("@EstadoCuenta", 'COTIZACION');
        $conn->Parametro("@CodPersonal", $pedido['PER_Codigo']);
        $conn->Parametro("@CodCliente", $pedido['CodCliente']);
        $conn->Parametro("@CodigoVenta", $pedido['PER_Codigo']);
        $conn->Parametro("@TipoVenta2", 'CONTADO');
        $conn->Parametro("@NroPedido", 'EFECTIVO');
        $conn->Parametro("@FechaAtencion", '19971231');
        $conn->Parametro("@HoraAtencion", '19971231');
        $conn->Parametro("@Responsable", 'WEB');
        $conn->Parametro("@Glosa", 'EFECTIVO');
        $conn->Parametro("@Otros1", '');
        $conn->Parametro("@Otros2", '');
        $conn->Parametro("@CodigoCaja", '');
        $conn->Parametro("@FechaVencimiento", '19971231');
        $conn->Parametro("@Sucursal", 'WEB');
        $conn->Parametro("@Encargado", $pedido['Observaciones']);
        $conn->Parametro("@Otros3", '');
        $conn->Parametro("@Otros4", '');
        $conn->Parametro("@Exonerado", $pedido['Exonerado']);
        $conn->Parametro("@Tipo", $pedido['TipoAccion']);
        $data = $conn->Procedimiento("dbo.PA_Ventas_WEB");  
        $data = json_decode(json_encode($data), true);
        $conn->Desconectar();
        
        $IT_Codigo = $data[0]['Codigo'];
        $Serie = $data[0]['Serie'];
        
        $detalles = (array) $pedido['DetallePedido'];
        
        $conn = new Conexion();
        $conn->Conectar();
        $data = [];
        for($i=0; $i<count($detalles); $i++){
            $dd = $detalles[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $IT_Codigo);
            $conn->Parametro("@Unidad", $dd['unidad']);
            $conn->Parametro("@Cantidad", $dd['cantidad']);
            $conn->Parametro("@Precio", $dd['venta']);
            $conn->Parametro("@SubTotal", $dd['importe']);
            $conn->Parametro("@CodigoArt", $dd['codigo']);
            $conn->Parametro("@CantidadString", $dd['cantidad']);
            $conn->Parametro("@Contenido", $dd['contenido']);
            $conn->Parametro("@TipoVenta", 'LIBRE');
            $conn->Parametro("@CantidadStock", $dd['cantidad']);
            $conn->Parametro("@DescuentoPorcentaje", 0);
            $conn->Parametro("@DescuentoSoles", 0);
            $conn->Parametro("@Costo", $dd['costo']);
            $conn->Parametro("@Exonerado", $dd['exonerado']);
            $data = $conn->Procedimiento("dbo.PA_DetalleVentas");   
        }
        $conn->Desconectar();
        
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $IT_Codigo);
        $conn->Parametro("@Tipo", '');
        $conn->Parametro("@Formato", $pedido['Formato']);
        $data = $conn->Procedimiento("dbo.PA_DocumentosImprimir");
        $conn->Desconectar();
        
        //$conn = new Conexion();
        //$conn->Conectar();
        //$conn->reiniciarArray();
        //$conn->Parametro("@IT_Codigo", $IT_Codigo);
        //$data = $conn->Procedimiento("ALMACEN.PA_CambiarEstadoInventarioTemporal");  
        //$conn->Desconectar();
        
        $data = ['rpta'=>'ok', 'Serie'=>$Serie];
        return json_encode($data);
	}
	
	public function PA_REGISTRAR_PEDIDO($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $pedido['Codigo']);
        $conn->Parametro("@Fecha", '19971231');
        $conn->Parametro("@Hora", '19971231');
        $conn->Parametro("@TipoVenta", 'PEDIDO');
        $conn->Parametro("@Serie", '');
        $conn->Parametro("@SubTotal", '0');
        $conn->Parametro("@IGV", '0');
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@Interez", 'NO');
        $conn->Parametro("@Estado", 'Habilitada');
        $conn->Parametro("@EstadoCuenta", 'PEDIDO');
        $conn->Parametro("@CodPersonal", $pedido['PER_Codigo']);
        $conn->Parametro("@CodCliente", '000001     ');
        $conn->Parametro("@CodigoVenta", $pedido['PER_Codigo']);
        $conn->Parametro("@TipoVenta2", 'CONTADO');
        $conn->Parametro("@NroPedido", 'EFECTIVO');
        $conn->Parametro("@FechaAtencion", '19971231');
        $conn->Parametro("@HoraAtencion", '19971231');
        $conn->Parametro("@Responsable", 'WEB');
        $conn->Parametro("@Glosa", 'EFECTIVO');
        $conn->Parametro("@Otros1", '');
        $conn->Parametro("@Otros2", '');
        $conn->Parametro("@CodigoCaja", '');
        $conn->Parametro("@FechaVencimiento", '19971231');
        $conn->Parametro("@Sucursal", 'WEB');
        $conn->Parametro("@Encargado", $pedido['Observaciones']);
        $conn->Parametro("@Otros3", '');
        $conn->Parametro("@Otros4", '');
        $conn->Parametro("@Exonerado", $pedido['Exonerado']);
        $conn->Parametro("@Tipo", $pedido['TipoAccion']);
        $data = $conn->Procedimiento("dbo.PA_Ventas_WEB");  
        $data = json_decode(json_encode($data), true);
        $conn->Desconectar();
        
        $IT_Codigo = $data[0]['Codigo'];
        $Serie = $data[0]['Serie'];
        
        $detalles = (array) $pedido['DetallePedido'];
        
        $conn = new Conexion();
        $conn->Conectar();
        $data = [];
        for($i=0; $i<count($detalles); $i++){
            $dd = $detalles[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $IT_Codigo);
            $conn->Parametro("@Unidad", $dd['unidad']);
            $conn->Parametro("@Cantidad", $dd['cantidad']);
            $conn->Parametro("@Precio", $dd['venta']);
            $conn->Parametro("@SubTotal", $dd['importe']);
            $conn->Parametro("@CodigoArt", $dd['codigo']);
            $conn->Parametro("@CantidadString", $dd['cantidad']);
            $conn->Parametro("@Contenido", $dd['contenido']);
            $conn->Parametro("@TipoVenta", 'LIBRE');
            $conn->Parametro("@CantidadStock", $dd['cantidad']);
            $conn->Parametro("@DescuentoPorcentaje", 0);
            $conn->Parametro("@DescuentoSoles", 0);
            $conn->Parametro("@Costo", $dd['costo']);
            $conn->Parametro("@Exonerado", $dd['exonerado']);
            $data = $conn->Procedimiento("dbo.PA_DetalleVentas");   
        }
        $conn->Desconectar();
        
        //$conn = new Conexion();
        //$conn->Conectar();
        //$conn->reiniciarArray();
        //$conn->Parametro("@IT_Codigo", $IT_Codigo);
        //$data = $conn->Procedimiento("ALMACEN.PA_CambiarEstadoInventarioTemporal");  
        //$conn->Desconectar();
        
        $data = ['rpta'=>'ok', 'Serie'=>$IT_Codigo];
        return json_encode($data);
	}
	
	public function PA_MODIFICAR_PEDIDO($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $pedido['Codigo']);
        $conn->Parametro("@CodCliente", $pedido['CodCliente']);
        $conn->Parametro("@CodMesa", $pedido['CodMesa']);
        $conn->Parametro("@NroPersonas", $pedido['NroPersonas']);
        $conn->Parametro("@Cliente", $pedido['Cliente']);
        $conn->Parametro("@Mesero", $pedido['Mesero']);
        $conn->Parametro("@Observaciones", $pedido['Observaciones']);
        $conn->Parametro("@TipoDocumento", $pedido['TipoDocumento']);
        $conn->Parametro("@Serie", $pedido['Serie']);
        $conn->Parametro("@Correlativo", $pedido['Correlativo']);
        $conn->Parametro("@SubTotal", $pedido['SubTotal']);
        $conn->Parametro("@IGV", $pedido['IGV']);
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@TipoPago", $pedido['TipoPago']);
        $conn->Parametro("@EstadoCuenta", $pedido['EstadoCuenta']);
        $conn->Parametro("@Estado", $pedido['Estado']);
        $conn->Parametro("@CodigoOperacionTarjeta", $pedido['CodigoOperacionTarjeta']);
        $conn->Parametro("@MontoOperacionTarjeta", $pedido['MontoOperacionTarjeta']);
        $conn->Parametro("@Impreso", $pedido['Impreso']);
        $conn->Parametro("@Dispositivo", $pedido['Dispositivo']);
        $conn->Parametro("@Forma", $pedido['Forma']);
        $conn->Parametro("@DetallePedido", $pedido['DetallePedido']);
        $data = $conn->Procedimiento("dbo.PA_MODIFICAR_PEDIDO");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_EliminarTablaTemporal_PorCodigoPedido($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_EliminarTablaTemporal_PorCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarTablaTemporal($detalles)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = [];
        for($i=0; $i<count($detalles); $i++){
            $dd = $detalles[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $dd['Codigo']);
            $conn->Parametro("@CodigoProducto", $dd['CodigoProducto']);
            $conn->Parametro("@Cantidad", $dd['Cantidad']);
            $conn->Parametro("@Descripcion", $dd['Descripcion']);
            $conn->Parametro("@Accion", $dd['Accion']);
            $conn->Parametro("@Precio", $dd['Precio']);
            $data = $conn->Procedimiento("dbo.PA_InsertarTablaTemporal");   
        }
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_ListarMesasxUbicacion($ubicacion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Ubicacion", $ubicacion);
        $data = $conn->Procedimiento("dbo.PA_ListarMesasxUbicacion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPersonalVer()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarPersonalVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCajaVer($sucursal)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@sucursal", $sucursal);
        $data = $conn->Procedimiento("dbo.PA_ListarCajaVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function ActualizaImpresionPedido($id, $valor)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $conn->Parametro("@Valor", 'NO');
        $data = $conn->Procedimiento("dbo.PA_ActualizaEstadoPedidoImpresion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $conn->Parametro("@cliente", $cliente);
        $conn->Parametro("@observaciones", $observaciones);
        $data = $conn->Procedimiento("dbo.PA_SOLO_CLIENTE");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarZonasMesa($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarZonasMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
}

$request = json_decode(file_get_contents('php://input'), true);

switch ($request['accion']) {
	case 'PA_REGISTRAR_COTIZACION':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_REGISTRAR_COTIZACION($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_REGISTRAR_PEDIDO':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_REGISTRAR_PEDIDO($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_ClienteWeb':
	    try{
		    $cliente = $request['cliente'];
        	$app = new Operaciones();
        	echo $app->PA_ClienteWeb($cliente);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_MODIFICAR_PEDIDO':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_MODIFICAR_PEDIDO($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
    case 'PA_ObtenerPersonal_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerPersonal_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_OpcionQuitarDetalle_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_OpcionQuitarDetalle_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulosWeb':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulosWeb($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerDetalleVentaWeb_PorCodigo':
		try{
        	$buscar = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetalleVentaWeb_PorCodigo($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_DocumentosImprimir':
		try{
        	$Codigo = $request['codigo'];
        	$Tipo = $request['tipo'];
        	$Formato = $request['formato'];
        	$app = new Operaciones();
        	echo $app->PA_DocumentosImprimir($Codigo, $Tipo, $Formato);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPersonalWeb_PorDescripcion':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonalWeb_PorDescripcion($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarVentasWeb_PorTipo':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
        	$CodVendedor = $request['CodVendedor'];
        	$Estado = $request['Estado'];
        	$Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarVentasWeb_PorTipo($Inicio, $Final, $CodVendedor, $Estado, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarClientesWeb':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarClientesWeb($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulos_Programacion_PorDescripcion':
		try{
        	$id = $request['descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulos_Programacion_PorDescripcion($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarPedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarDetallesDePedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarDetallesDePedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_GeneraCodigoPedido':
		try{
        	$app = new Operaciones();
        	echo $app->PA_GeneraCodigoPedido();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_EliminarTablaTemporal_PorCodigoPedido':
		try{
		    $id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_EliminarTablaTemporal_PorCodigoPedido($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarTablaTemporal':
		try{
		    $detalles = $request['detalles'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarTablaTemporal($detalles);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarMesasxUbicacion':
		try{
		    $ubicacion = $request['ubicacion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarMesasxUbicacion($ubicacion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPersonalVer':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonalVer();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajaVer':
		try{
		    $sucursal = $request['sucursal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCajaVer($sucursal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'ActualizaImpresionPedido':
		try{
		    $id = $request['codigo'];
		    $valor = $request['valor'];
        	$app = new Operaciones();
        	echo $app->ActualizaImpresionPedido($id, $valor);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_SOLO_CLIENTE':
		try{
		    $PED_Codigo = $request['PED_Codigo'];
		    $cliente = $request['cliente'];
		    $observaciones = $request['observaciones'];
        	$app = new Operaciones();
        	echo $app->PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarZonasMesa':
		try{
		    $descripcion = $request['Descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarZonasMesa($descripcion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
}



