<?php
include '../ConsumoApiLaBanda/Conexion.php';
header("Content-Type: application/json; charset=UTF-8");

class Operaciones
{
    public function PA_OpcionQuitarDetalle_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_OpcionQuitarDetalle_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarComidas_ConReceta($Descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $Descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarComidas_ConReceta");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ReporteComidas_PorFechas($inicio, $final, $cat, $panel, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Inicio", $inicio);
        $conn->Parametro("@Fin", $final);
        $conn->Parametro("@Cat", $cat);
        $conn->Parametro("@Panel", $panel);
        $conn->Parametro("@Tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ReporteComidas_PorFechas");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ReporteInsumos_AlaFecha($inicio1, $inicio2, $inicio3, $inicio4, $inicio5, $inicio6, $inicio7, $final, $cat, $panel, $Nombre, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio1", $inicio1);
        $conn->Parametro("@Inicio2", $inicio2);
        $conn->Parametro("@Inicio3", $inicio3);
        $conn->Parametro("@Inicio4", $inicio4);
        $conn->Parametro("@Inicio5", $inicio5);
        $conn->Parametro("@Inicio6", $inicio6);
        $conn->Parametro("@Inicio7", $inicio7);
        $conn->Parametro("@Fin", $final);
        $conn->Parametro("@Cat", $cat);
        $conn->Parametro("@Panel", $panel);
        $conn->Parametro("@Nombre", $Nombre);
        $conn->Parametro("@Tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ReporteInsumos_AlaFecha");
        $conn->Desconectar();
        return json_encode($data);
	}
	
    public function PA_ObtenerPersonal_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPersonal_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulos_Programacion_PorDescripcion($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulos_Programacion_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data);
	}
    
	public function PA_ListarPedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarPedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarDetallesDePedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarDetallesDePedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_GeneraCodigoPedido()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_GeneraCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_REGISTRAR_PEDIDO($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@CodCliente", $pedido['CodCliente']);
        $conn->Parametro("@CodMesa", $pedido['CodMesa']);
        $conn->Parametro("@NroPersonas", $pedido['NroPersonas']);
        $conn->Parametro("@Cliente", $pedido['Cliente']);
        $conn->Parametro("@Mesero", $pedido['Mesero']);
        $conn->Parametro("@Observaciones", $pedido['Observaciones']);
        $conn->Parametro("@TipoDocumento", $pedido['TipoDocumento']);
        $conn->Parametro("@Serie", $pedido['Serie']);
        $conn->Parametro("@Correlativo", $pedido['Correlativo']);
        $conn->Parametro("@SubTotal", $pedido['SubTotal']);
        $conn->Parametro("@IGV", $pedido['IGV']);
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@TipoPago", $pedido['TipoPago']);
        $conn->Parametro("@EstadoCuenta", $pedido['EstadoCuenta']);
        $conn->Parametro("@Estado", $pedido['Estado']);
        $conn->Parametro("@CodigoOperacionTarjeta", $pedido['CodigoOperacionTarjeta']);
        $conn->Parametro("@MontoOperacionTarjeta", $pedido['MontoOperacionTarjeta']);
        $conn->Parametro("@Impreso", $pedido['Impreso']);
        $conn->Parametro("@Dispositivo", $pedido['Dispositivo']);
        $conn->Parametro("@Forma", $pedido['Forma']);
        $conn->Parametro("@DetallePedido", $pedido['DetallePedido']);
        $conn->Parametro("@PER_Codigo", $pedido['PER_Codigo']);
        $conn->Parametro("@sucursal", $pedido['sucursal']);
        $conn->Parametro("@FDM_Codigo", $pedido['FDM_Codigo']);
        $conn->Parametro("@ClienteJE", $pedido['ClienteJE']);
        $conn->Parametro("@CelularJE", $pedido['CelularJE']);
        $data = $conn->Procedimiento("dbo.PA_REGISTRAR_PEDIDO");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'datos'=>$data];
        return json_encode($data);
	}
	
	public function PA_MODIFICAR_PEDIDO($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $pedido['Codigo']);
        $conn->Parametro("@CodCliente", $pedido['CodCliente']);
        $conn->Parametro("@CodMesa", $pedido['CodMesa']);
        $conn->Parametro("@NroPersonas", $pedido['NroPersonas']);
        $conn->Parametro("@Cliente", $pedido['Cliente']);
        $conn->Parametro("@Mesero", $pedido['Mesero']);
        $conn->Parametro("@Observaciones", $pedido['Observaciones']);
        $conn->Parametro("@TipoDocumento", $pedido['TipoDocumento']);
        $conn->Parametro("@Serie", $pedido['Serie']);
        $conn->Parametro("@Correlativo", $pedido['Correlativo']);
        $conn->Parametro("@SubTotal", $pedido['SubTotal']);
        $conn->Parametro("@IGV", $pedido['IGV']);
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@TipoPago", $pedido['TipoPago']);
        $conn->Parametro("@EstadoCuenta", $pedido['EstadoCuenta']);
        $conn->Parametro("@Estado", $pedido['Estado']);
        $conn->Parametro("@CodigoOperacionTarjeta", $pedido['CodigoOperacionTarjeta']);
        $conn->Parametro("@MontoOperacionTarjeta", $pedido['MontoOperacionTarjeta']);
        $conn->Parametro("@Impreso", $pedido['Impreso']);
        $conn->Parametro("@Dispositivo", $pedido['Dispositivo']);
        $conn->Parametro("@Forma", $pedido['Forma']);
        $conn->Parametro("@DetallePedido", $pedido['DetallePedido']);
        $conn->Parametro("@FDM_Codigo", $pedido['FDM_Codigo']);
        $conn->Parametro("@ClienteJE", $pedido['ClienteJE']);
        $conn->Parametro("@CelularJE", $pedido['CelularJE']);
        $data = $conn->Procedimiento("dbo.PA_MODIFICAR_PEDIDO");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_EliminarTablaTemporal_PorCodigoPedido($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_EliminarTablaTemporal_PorCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarTablaTemporal($detalles)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = [];
        for($i=0; $i<count($detalles); $i++){
            $dd = $detalles[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $dd['Codigo']);
            $conn->Parametro("@CodigoProducto", $dd['CodigoProducto']);
            $conn->Parametro("@Cantidad", $dd['Cantidad']);
            $conn->Parametro("@Descripcion", $dd['Descripcion']);
            $conn->Parametro("@Accion", $dd['Accion']);
            $conn->Parametro("@Precio", $dd['Precio']);
            $data = $conn->Procedimiento("dbo.PA_InsertarTablaTemporal");   
        }
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_ListarMesasxUbicacion($ubicacion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Ubicacion", $ubicacion);
        $data = $conn->Procedimiento("dbo.PA_ListarMesasxUbicacion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPersonalVer()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarPersonalVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCajaVer($sucursal)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@sucursal", $sucursal);
        $data = $conn->Procedimiento("dbo.PA_ListarCajaVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function ActualizaImpresionPedido($id, $valor)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $conn->Parametro("@Valor", 'NO');
        $data = $conn->Procedimiento("dbo.PA_ActualizaEstadoPedidoImpresion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $conn->Parametro("@cliente", $cliente);
        $conn->Parametro("@observaciones", $observaciones);
        $data = $conn->Procedimiento("dbo.PA_SOLO_CLIENTE");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarZonasMesa($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarZonasMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCategorias_PorAbreviatura($abrevitura)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@abreviatura", $abrevitura);
        $data = $conn->Procedimiento("dbo.PA_ListarCategorias_PorAbreviatura");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulosxCategoria_Programacion($categoria)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Categoria", $categoria);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulosxCategoria_Programacion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPermisosWeb_PorUsuario($codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarPermisosWeb_PorUsuario");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerEstadoSeEstaCobrando_PorCodigo($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerEstadoSeEstaCobrando_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_EstadoCaja_xCodigo_WEB($CD_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CD_Codigo", $CD_Codigo);
        $data = $conn->Procedimiento("dbo.PA_EstadoCaja_xCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarIngresosDineroEntreFechasXCaja($Inicio, $Final, $Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarIngresosDineroEntreFechasXCaja");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarSalidasDineroEntreFechasxCaja($Inicio, $Final, $Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinak", $Final);
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarSalidasDineroEntreFechasxCaja");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarVentas_WEB($Inicio, $Final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $data = $conn->Procedimiento("dbo.PA_ListarVentas_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulos_PorTipo($Tipo, $Descripcion, $Categoria)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Tipo", $Tipo);
        $conn->Parametro("@Descripcion", $Descripcion);
        $conn->Parametro("@Categoria", $Categoria);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulos_PorTipo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarInsumos_WEB($descripcion, $categoria, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $descripcion);
        $conn->Parametro("@cat", $categoria);
        $conn->Parametro("@tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ListarInsumos_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCategorias_PorTipoWEB($Tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Tipo", $Tipo);
        $data = $conn->Procedimiento("dbo.PA_ListarCategorias_PorTipoWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarBebidasStockMinimo()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", "Habilitado");
        $data = $conn->Procedimiento("dbo.PA_ListarBebidasStockMinimo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarInsumosStockMinimo()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", "Habilitado");
        $data = $conn->Procedimiento("dbo.PA_ListarInsumosStockMinimo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCajasxFecha($inicio, $final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@fechaInicio", $inicio);
        $conn->Parametro("@fechaFinal", $final);
        $data = $conn->Procedimiento("dbo.PA_ListarCajasxFecha");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_BuscarFormulario_PorCliente_WEB($FDM_NombreCliente, $FDM_Tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FDM_NombreCliente", $FDM_NombreCliente);
        $conn->Parametro("@FDM_Tipo", $FDM_Tipo);
        $data = $conn->Procedimiento("dbo.PA_BuscarFormulario_PorCliente_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerPedido_PorCodigo_WEB($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPedido_PorCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerDetallePedido_PorCodigo_WEB($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerDetallePedido_PorCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerFormularioDeliveryMostrador_PorCodigo($FDM_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@FDM_Codigo", $FDM_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerFormularioDeliveryMostrador_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarFormularioDeliveryMostrador($obj){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@FDM_Codigo", $obj['FDM_Codigo']);
        $conn->Parametro("@FDM_Tipo", $obj['FDM_Tipo']);
        $conn->Parametro("@FDM_Estado", $obj['FDM_Estado']);
        $conn->Parametro("@FDM_NombreCliente", $obj['FDM_NombreCliente']);
        $conn->Parametro("@FDM_Celular", $obj['FDM_Celular']);
        $data = $conn->Procedimiento("dbo.PA_InsertarFormularioDeliveryMostrador");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'datos'=>$data];
        return json_encode($data);
	}
}

$request = json_decode(file_get_contents('php://input'), true);

switch ($request['accion']) {
	case 'PA_REGISTRAR_PEDIDO':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_REGISTRAR_PEDIDO($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_MODIFICAR_PEDIDO':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_MODIFICAR_PEDIDO($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
    case 'PA_ObtenerPersonal_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerPersonal_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_OpcionQuitarDetalle_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_OpcionQuitarDetalle_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarComidas_ConReceta':
		try{
        	$Descripcion = $request['Descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarComidas_ConReceta($Descripcion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ReporteComidas_PorFechas':
		try{
        	$Inicio = $request['Inicio'];
        	$Fin = $request['Fin'];
        	$Cat = $request['Cat'];
        	$Panel = $request['Panel'];
        	$Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ReporteComidas_PorFechas($Inicio, $Fin, $Cat, $Panel, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ReporteInsumos_AlaFecha':
		try{
        	$Inicio1 = $request['Inicio1'];
        	$Inicio2 = $request['Inicio2'];
        	$Inicio3 = $request['Inicio3'];
        	$Inicio4 = $request['Inicio4'];
        	$Inicio5 = $request['Inicio5'];
        	$Inicio6 = $request['Inicio6'];
        	$Inicio7 = $request['Inicio7'];
        	$Fin = $request['Fin'];
        	$Cat = $request['Cat'];
        	$Panel = $request['Panel'];
        	$Nombre = $request['Nombre'];
        	$Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ReporteInsumos_AlaFecha($Inicio1, $Inicio2, $Inicio3, $Inicio4, $Inicio5, $Inicio6, $Inicio7, $Fin, $Cat, $Panel, $Nombre, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulos_Programacion_PorDescripcion':
		try{
        	$id = $request['descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulos_Programacion_PorDescripcion($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarPedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarDetallesDePedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarDetallesDePedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_GeneraCodigoPedido':
		try{
        	$app = new Operaciones();
        	echo $app->PA_GeneraCodigoPedido();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_EliminarTablaTemporal_PorCodigoPedido':
		try{
		    $id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_EliminarTablaTemporal_PorCodigoPedido($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarTablaTemporal':
		try{
		    $detalles = $request['detalles'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarTablaTemporal($detalles);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarMesasxUbicacion':
		try{
		    $ubicacion = $request['ubicacion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarMesasxUbicacion($ubicacion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPersonalVer':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonalVer();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajaVer':
		try{
		    $sucursal = $request['sucursal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCajaVer($sucursal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'ActualizaImpresionPedido':
		try{
		    $id = $request['codigo'];
		    $valor = $request['valor'];
        	$app = new Operaciones();
        	echo $app->ActualizaImpresionPedido($id, $valor);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_SOLO_CLIENTE':
		try{
		    $PED_Codigo = $request['PED_Codigo'];
		    $cliente = $request['cliente'];
		    $observaciones = $request['observaciones'];
        	$app = new Operaciones();
        	echo $app->PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarZonasMesa':
		try{
		    $descripcion = $request['Descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarZonasMesa($descripcion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	
	case 'PA_ListarCategorias_PorAbreviatura':
		try{
		    $abreviatura = $request['abreviatura'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCategorias_PorAbreviatura($abreviatura);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulosxCategoria_Programacion':
		try{
		    $categoria = $request['Categoria'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulosxCategoria_Programacion($categoria);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPermisosWeb_PorUsuario':
		try{
		    $id = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPermisosWeb_PorUsuario($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerEstadoSeEstaCobrando_PorCodigo':
		try{
		    $PER_Codigo = $request['PER_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerEstadoSeEstaCobrando_PorCodigo($PER_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_EstadoCaja_xCodigo_WEB':
	    try{
		    $CD_Codigo = $request['CD_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_EstadoCaja_xCodigo_WEB($CD_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarIngresosDineroEntreFechasXCaja':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarIngresosDineroEntreFechasXCaja($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarSalidasDineroEntreFechasxCaja':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarSalidasDineroEntreFechasxCaja($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarVentas_WEB':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarVentas_WEB($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulos_PorTipo':
	    try{
		    $Tipo = $request['Tipo'];
		    $Descripcion = $request['Descripcion'];
		    $Categoria = $request['Categoria'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulos_PorTipo($Tipo, $Descripcion, $Categoria);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarInsumos_WEB':
	    try{
		    $Descripcion = $request['descrip'];
		    $Categoria = $request['cat'];
		    $Tipo = $request['tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarInsumos_WEB($Descripcion, $Categoria, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarCategorias_PorTipoWEB':
	    try{
		    $Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCategorias_PorTipoWEB($Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarBebidasStockMinimo':
	    try{
        	$app = new Operaciones();
        	echo $app->PA_ListarBebidasStockMinimo();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarInsumosStockMinimo':
	    try{
        	$app = new Operaciones();
        	echo $app->PA_ListarInsumosStockMinimo();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajasxFecha':
	    try{
	        $fechaInicio = $request['fechaInicio'];
	        $fechaFinal = $request['fechaFinal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCajasxFecha($fechaInicio, $fechaFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_BuscarFormulario_PorCliente_WEB':
	    try{
	        $FDM_NombreCliente = $request['FDM_NombreCliente'];
	        $FDM_Tipo = $request['FDM_Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_BuscarFormulario_PorCliente_WEB($FDM_NombreCliente, $FDM_Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerPedido_PorCodigo_WEB':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerPedido_PorCodigo_WEB($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerDetallePedido_PorCodigo_WEB':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetallePedido_PorCodigo_WEB($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerFormularioDeliveryMostrador_PorCodigo':
	    try{
	        $FDM_Codigo = $request['FDM_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerFormularioDeliveryMostrador_PorCodigo($FDM_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarFormularioDeliveryMostrador':
	    try{
	        $obj = $request['obj'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarFormularioDeliveryMostrador($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
}



