<?php

include '../ConsumoApiDemoSis/Conexion.php';
header("Content-Type: application/json; charset=UTF-8");

class Operaciones
{
    public function PA_OpcionQuitarDetalle_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_OpcionQuitarDetalle_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarProductos_PorDescripcion($buscar1, $buscar2, $buscar3, $buscar4, $buscar5, $buscar6)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar1);
       
        $data = $conn->Procedimiento("PA_ListarArticulosWeb2");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarConceptosI()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", 'Habilitado');
       
        $data = $conn->Procedimiento("PA_ListaConceptos");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarConceptosS()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", 'Habilitado');
       
        $data = $conn->Procedimiento("PA_ListaConceptosS");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function IngresarArticuloWeb($Codigo, $Desc, $Unidad,$Precio)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@ART_Codigo", $Codigo);
        $conn->Parametro("@ART_Descripcion", $Desc);
        $conn->Parametro("@ART_Descripcion2", $Unidad);
        $conn->Parametro("@ART_Precio1", $Precio);
        $data = $conn->Procedimiento("dbo.IngresarArticuloWeb");
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'Serie' => $Codigo];
        return json_encode($data);
	}
	public function PA_InsertarIngreso($Codigo, $Desc,$Precio,$Fecha,$Caja,$Perso)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@ID_CODIGO", $Codigo);
        $conn->Parametro("@ID_FECHA", $Fecha);
        $conn->Parametro("@ID_Monto", $Precio);
        $conn->Parametro("@ID_Concepto", $Desc);
        $conn->Parametro("@PER_CODIGO", $Perso);
        $conn->Parametro("@CD_Codigo", $Caja);
        $data = $conn->Procedimiento("dbo.PA_InsertarIngreso");
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'Serie' => $Codigo];
        return json_encode($data);
	}
	public function PA_InsertarEgreso($Codigo, $Desc,$Precio,$Fecha,$Caja,$Perso,$Desti)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@ID_CODIGO", $Codigo);
        $conn->Parametro("@ID_FECHA", $Fecha);
        $conn->Parametro("@ID_Monto", $Precio);
        $conn->Parametro("@ID_Concepto", $Desc);
        $conn->Parametro("@PER_CODIGO", $Perso);
        $conn->Parametro("@CD_Codigo", $Caja);
        $conn->Parametro("@SAL_Destinatario", $Desti);
        $data = $conn->Procedimiento("dbo.PA_InsertarEgreso");
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'Serie' => $Codigo];
        return json_encode($data);
	}
	public function IngresarConceptoIWeb($Desc)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CON_Descripcion", $Desc);
        
        $data = $conn->Procedimiento("dbo.PA_IngresarConceptoI");
        $data = json_decode(json_encode($data), true);
        $conn->Desconectar();

        $Codigopre = $data[0]['CON_Codigo'];
        $Codigo = str_pad($Codigopre,6,"0",STR_PAD_LEFT); 
        $data = ['rpta'=>'ok', 'Serie' => $Codigo, 'Codigo'=> $Codigopre];
        return json_encode($data);
	}
	public function IngresarConceptoSWeb($Desc)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CON_Descripcion", $Desc);
        
        $data = $conn->Procedimiento("dbo.PA_IngresarConceptoS");
        $data = json_decode(json_encode($data), true);
        $conn->Desconectar();

        $Codigopre = $data[0]['CON_Codigo'];
        $Codigo = str_pad($Codigopre,6,"0",STR_PAD_LEFT); 
        $data = ['rpta'=>'ok', 'Serie' => $Codigo, 'Codigo'=> $Codigopre];
        return json_encode($data);
	}
	public function PA_DocumentosImprimir($codigo, $tipo, $formato)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $conn->Parametro("@Tipo", $tipo);
        $conn->Parametro("@formato", $formato);
        $data = $conn->Procedimiento("dbo.PA_DocumentosImprimir");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ObtenerVenta_PorCodigo_Cabecera($VEN_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_ObtenerVenta_PorCodigo_Cabecera");
        $conn->Desconectar();
        return json_encode($data);
	}
	
		public function PA_ObtenerNArticulo()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("PA_ObtenerNArticulo");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ObtenerNingreso()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("PA_ObtenerNIngreso");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ObtenerNsalida()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("PA_ObtenerNSalida");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_Obtener_notas_electronicasWeb($VEN_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@NC_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_Obtener_notas_electronicasWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
    public function PA_ObtenerVenta_PorCodigo_Detalle($VEN_Codigo)
	{
	    //return '$VEN_Codigo: ' + $VEN_Codigo;
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_ObtenerVenta_PorCodigo_Detalle");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ObtenerDetallesVenta_PorCodigo($VEN_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_ObtenerDetalleVentaWeb_PorCodigo2");
        $conn->Desconectar();
        return json_encode($data);
	}
	    public function PA_ObtenerDetalleNCWeb_PorCodigo($VEN_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("PA_ObtenerDetalleNCWeb_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarArticulosWeb($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulosWeb2");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarVentasWeb_PorTipo($inicio, $final, $codvendedor, $estado, $tipo, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $inicio);
        $conn->Parametro("@Final", $final);
        $conn->Parametro("@CodVendedor", $codvendedor);
        $conn->Parametro("@Estado", $estado);
        $conn->Parametro("@Tipo", $tipo);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarVentasWeb_PorTipo");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ListarVentas2($Inicio, $Final, $Cliente, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@Cliente", $Cliente);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("PA_ListarVentas_Web2");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarCompras($Inicio, $Final, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("PA_ListarNotaIngresoWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_Facturacion($Inicio, $Final, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("PA_ListarFacturacionWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_NotaCredito($Inicio, $Final, $buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio", $Inicio);
        $conn->Parametro("@Final", $Final);
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("PA_listar_notas_electronicasWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarPersonalWeb_PorDescripcion($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarPersonalWeb_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarClientesWeb($buscar)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@buscar", $buscar);
        $data = $conn->Procedimiento("dbo.PA_ListarClientesWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_Pedido_JE_ConTransaccion_Eliminar($PED_Codigo, $MES_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@$PED_Codigo", $PED_Codigo);
        $conn->Parametro("@$MES_Codigo", $MES_Codigo);
        $data = $conn->Procedimiento("dbo.PA_Pedido_JE_ConTransaccion_Eliminar");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_VerCambios()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_VerCambios");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarComidas_ConReceta($Descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $Descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarComidas_ConReceta");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ValiarPlatosProgramados($_platosProgramados, $_cantidadProgramados)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@codigos", $_platosProgramados);
        $conn->Parametro("@cantidades", $_cantidadProgramados);
        $data = $conn->Procedimiento("dbo.PA_ValiarPlatosProgramados");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ReporteComidas_PorFechas($inicio, $final, $cat, $panel, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Inicio", $inicio);
        $conn->Parametro("@Fin", $final);
        $conn->Parametro("@Cat", $cat);
        $conn->Parametro("@Panel", $panel);
        $conn->Parametro("@Tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ReporteComidas_PorFechas");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerLogoSistema()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        //$conn->Parametro("@Descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ObtenerLogoSistemaWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ReporteInsumos_AlaFecha($inicio1, $inicio2, $inicio3, $inicio4, $inicio5, $inicio6, $inicio7, $final, $cat, $panel, $Nombre, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Inicio1", $inicio1);
        $conn->Parametro("@Inicio2", $inicio2);
        $conn->Parametro("@Inicio3", $inicio3);
        $conn->Parametro("@Inicio4", $inicio4);
        $conn->Parametro("@Inicio5", $inicio5);
        $conn->Parametro("@Inicio6", $inicio6);
        $conn->Parametro("@Inicio7", $inicio7);
        $conn->Parametro("@Fin", $final);
        $conn->Parametro("@Cat", $cat);
        $conn->Parametro("@Panel", $panel);
        $conn->Parametro("@Nombre", $Nombre);
        $conn->Parametro("@Tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ReporteInsumos_AlaFecha");
        $conn->Desconectar();
        return json_encode($data);
	}
	
    public function PA_ObtenerPersonal_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPersonal_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulos_Programacion_PorDescripcion($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulos_Programacion_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data);
	}
    
	public function PA_ListarPedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarPedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarDetallesDePedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarDetallesDePedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_GeneraCodigoPedido()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_GeneraCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_Ventas_WEB($pedido){
	    try{
	        $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $pedido['Codigo']);
            $conn->Parametro("@Fecha", '');
            $conn->Parametro("@Hora", '');
            $conn->Parametro("@TipoVenta", $pedido['TipoDocumento']);
            $conn->Parametro("@Serie", '');
            $conn->Parametro("@SubTotal", 0);
            $conn->Parametro("@IGV", 0);
            $conn->Parametro("@Total", $pedido['Total']);
            $conn->Parametro("@Interez", '');
            $conn->Parametro("@Estado", 'Habilitada');
            $conn->Parametro("@EstadoCuenta", 'PENDIENTE');
            $conn->Parametro("@CodPersonal", $pedido['PER_Codigo']);
            $conn->Parametro("@CodCliente", $pedido['CodCliente']);
            $conn->Parametro("@CodigoVenta", '');
            $conn->Parametro("@TipoVenta2", 'CONTADO');
            $conn->Parametro("@NroPedido", '');
            $conn->Parametro("@FechaAtencion", '');
            $conn->Parametro("@HoraAtencion", '');
            $conn->Parametro("@Responsable", '');
            $conn->Parametro("@Glosa",'');
            $conn->Parametro("@Otros1", '');
            $conn->Parametro("@Otros2", '');
            $conn->Parametro("@CodigoCaja", '');
            $conn->Parametro("@FechaVencimiento", '');
            $conn->Parametro("@Sucursal", '');
            $conn->Parametro("@Encargado", $pedido['Observaciones']);
            $conn->Parametro("@Otros3", 'WEB');
            $conn->Parametro("@Otros4", $pedido['Origen']);
            $conn->Parametro("@Exonerado", 0);
            $conn->Parametro("@Tipo", $pedido['TipoAccion']);
            $data = $conn->Procedimiento("dbo.PA_Ventas_WEB");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Codigo = $data[0]['Codigo'];
            $Serie = $data[0]['Serie'];
            
            $detalles = (array) $pedido['DetallePedido'];
            
            $conn = new Conexion();
            $conn->Conectar();
            $data = [];
            for($i=0; $i<count($detalles); $i++){
                $dd = $detalles[$i];
                $conn->reiniciarArray();
                $conn->Parametro("@Codigo", $Codigo);
                $conn->Parametro("@Unidad", $dd['unidad']);
                $conn->Parametro("@Cantidad", $dd['cantidad']);
                $conn->Parametro("@Precio", $dd['venta']);
                $conn->Parametro("@SubTotal", $dd['importe']);
                $conn->Parametro("@CodigoArt", $dd['codigo']);
                $conn->Parametro("@CantidadString", $dd['cantidad']);
                $conn->Parametro("@Contenido", $dd['contenido']);
                $conn->Parametro("@TipoVenta", 'LIBRE');
                $conn->Parametro("@CantidadStock", 0);
                $conn->Parametro("@DescuentoPorcentaje", 0);
                $conn->Parametro("@DescuentoSoles", 0);
                $conn->Parametro("@Costo", $dd['costo']);
                $conn->Parametro("@Exonerado", $dd['exonerado']);
                $data = $conn->Procedimiento("dbo.PA_DetalleVentas");   
            }
            $conn->Desconectar();
            
            $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@Tipo", $pedido['TipoDocumento']);
            $conn->Parametro("@VEN_Codigo", $Codigo);
            $data = $conn->Procedimiento("dbo.PA_ActualizarVenta_Web");  
            $conn->Desconectar();
             
            $data = ['rpta'=>'ok', 'Serie' => $Codigo];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['rpta'=>'error'.$ex->getMessage()];
            return json_encode($data);
	    }
	}
	
	public function PA_Ventas_WEB2($pedido){
	    try{
	        $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $pedido['Codigo']);
            $conn->Parametro("@Fecha", '');
            $conn->Parametro("@Hora", '');
            $conn->Parametro("@TipoVenta", $pedido['TipoDocumento']);
            $conn->Parametro("@Serie", '');
            $conn->Parametro("@SubTotal", 0);
            $conn->Parametro("@IGV", 0);
            $conn->Parametro("@Total", $pedido['Total']);
            $conn->Parametro("@Interez", '');
            $conn->Parametro("@Estado", 'Habilitada');
            $conn->Parametro("@EstadoCuenta", 'PENDIENTE');
            $conn->Parametro("@CodPersonal", $pedido['PER_Codigo']);
            $conn->Parametro("@CodCliente", $pedido['CodCliente']);
            $conn->Parametro("@CodigoVenta", '');
            $conn->Parametro("@TipoVenta2", $pedido['Condicion']);
            $conn->Parametro("@NroPedido", $pedido['FP_Codigo']);
            $conn->Parametro("@FechaAtencion", '');
            $conn->Parametro("@HoraAtencion", '');
            $conn->Parametro("@Responsable", '');
            $conn->Parametro("@Glosa", $pedido['Glosa']);
            $conn->Parametro("@Otros1", '');
            $conn->Parametro("@Otros2", '');
            $conn->Parametro("@CodigoCaja", '');
            $conn->Parametro("@FechaVencimiento", '');
            $conn->Parametro("@Sucursal", '');
            $conn->Parametro("@Encargado", $pedido['Observaciones']);
            $conn->Parametro("@Otros3", 'WEB');
            $conn->Parametro("@Otros4", $pedido['Origen']);
            $conn->Parametro("@Exonerado", 0);
            $conn->Parametro("@VEN_NroOperacion", $pedido['NroOperacion']);
            $conn->Parametro("@VEN_Efectivo", $pedido['Efectivo']);
            $conn->Parametro("@VEN_Tarjeta", $pedido['Tarjeta']);
            $conn->Parametro("@DiasCredito", $pedido['DiasCredito']);
            $conn->Parametro("@SumaCaja", $pedido['SumaCaja']);
            $conn->Parametro("@Tipo", $pedido['TipoAccion']);
            $data = $conn->Procedimiento("dbo.PA_Ventas_WEB2");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Codigo = $data[0]['Codigo'];
            $Serie = $data[0]['Serie'];
            
            $detalles = (array) $pedido['DetallePedido'];
            
            $conn = new Conexion();
            $conn->Conectar();
            $data = [];
            for($i=0; $i<count($detalles); $i++){
                $dd = $detalles[$i];
                $conn->reiniciarArray();
                $conn->Parametro("@Codigo", $Codigo);
                $conn->Parametro("@Unidad", $dd['unidad']);
                $conn->Parametro("@Cantidad", $dd['cantidad']);
                $conn->Parametro("@Precio", $dd['venta']);
                $conn->Parametro("@SubTotal", $dd['importe']);
                $conn->Parametro("@CodigoArt", $dd['codigo']);
                $conn->Parametro("@CantidadString", $dd['cantidad']);
                $conn->Parametro("@Contenido", $dd['contenido']);
                $conn->Parametro("@TipoVenta", 'LIBRE');
                $conn->Parametro("@CantidadStock", 0);
                $conn->Parametro("@DescuentoPorcentaje", 0);
                $conn->Parametro("@DescuentoSoles", 0);
                $conn->Parametro("@Costo", $dd['costo']);
                $conn->Parametro("@Exonerado", $dd['exonerado']);
                $data = $conn->Procedimiento("dbo.PA_DetalleVentas");   
            }
            $conn->Desconectar();
            
            $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@Tipo",'ATENDIDO');
            $conn->Parametro("@VEN_Codigo", $Codigo);
            $data = $conn->Procedimiento("dbo.PA_ActualizarVenta_Web");  
            $conn->Desconectar();
             
            $data = ['rpta'=>'ok', 'Serie' => $Codigo, 'NroGenerado' => $Serie];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['rpta'=>'error'.$ex->getMessage()];
            return json_encode($data);
	    }
	}
	
	public function PA_ClienteWeb($cliente){
	    try{
	        $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@documento", $cliente['documento']);
            $conn->Parametro("@cliente", $cliente['cliente']);
            $conn->Parametro("@direccion", $cliente['direccion']);
            $data = $conn->Procedimiento("dbo.PA_ClienteWeb");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Codigo = $data[0]['CodigoGenerado'];
            $Existe = $data[0]['Existe'];
             
            $data = ['CodigoGenerado' => $Codigo, 'Existe' => $Existe];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['CodigoGenerado' => '000000', 'Existe' => 'NO'];
            return json_encode($data);
	    }
	}
	
	public function PA_MODIFICAR_PEDIDO($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $pedido['Codigo']);
        $conn->Parametro("@CodCliente", $pedido['CodCliente']);
        $conn->Parametro("@CodMesa", $pedido['CodMesa']);
        $conn->Parametro("@NroPersonas", $pedido['NroPersonas']);
        $conn->Parametro("@Cliente", $pedido['Cliente']);
        $conn->Parametro("@Mesero", $pedido['Mesero']);
        $conn->Parametro("@Observaciones", $pedido['Observaciones']);
        $conn->Parametro("@TipoDocumento", $pedido['TipoDocumento']);
        $conn->Parametro("@Serie", $pedido['Serie']);
        $conn->Parametro("@Correlativo", $pedido['Correlativo']);
        $conn->Parametro("@SubTotal", $pedido['SubTotal']);
        $conn->Parametro("@IGV", $pedido['IGV']);
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@TipoPago", $pedido['TipoPago']);
        $conn->Parametro("@EstadoCuenta", $pedido['EstadoCuenta']);
        $conn->Parametro("@Estado", $pedido['Estado']);
        $conn->Parametro("@CodigoOperacionTarjeta", $pedido['CodigoOperacionTarjeta']);
        $conn->Parametro("@MontoOperacionTarjeta", $pedido['MontoOperacionTarjeta']);
        $conn->Parametro("@Impreso", $pedido['Impreso']);
        $conn->Parametro("@Dispositivo", $pedido['Dispositivo']);
        $conn->Parametro("@Forma", $pedido['Forma']);
        $conn->Parametro("@DetallePedido", $pedido['DetallePedido']);
        $conn->Parametro("@FDM_Codigo", $pedido['FDM_Codigo']);
        $conn->Parametro("@ClienteJE", $pedido['ClienteJE']);
        $conn->Parametro("@CelularJE", $pedido['CelularJE']);
        $data = $conn->Procedimiento("dbo.PA_MODIFICAR_PEDIDO");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_EliminarTablaTemporal_PorCodigoPedido($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_EliminarTablaTemporal_PorCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarTablaTemporal($detalles)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = [];
        for($i=0; $i<count($detalles); $i++){
            $dd = $detalles[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $dd['Codigo']);
            $conn->Parametro("@CodigoProducto", $dd['CodigoProducto']);
            $conn->Parametro("@Cantidad", $dd['Cantidad']);
            $conn->Parametro("@Descripcion", $dd['Descripcion']);
            $conn->Parametro("@Accion", $dd['Accion']);
            $conn->Parametro("@Precio", $dd['Precio']);
            $data = $conn->Procedimiento("dbo.PA_InsertarTablaTemporal");   
        }
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_ListarMesasxUbicacion($ubicacion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Ubicacion", $ubicacion);
        $data = $conn->Procedimiento("dbo.PA_ListarMesasxUbicacion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPersonalVer()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarPersonalVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCajaVer($sucursal)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@sucursal", $sucursal);
        $data = $conn->Procedimiento("dbo.PA_ListarCajaVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function ActualizaImpresionPedido($id, $valor)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $conn->Parametro("@Valor", 'NO');
        $data = $conn->Procedimiento("dbo.PA_ActualizaEstadoPedidoImpresion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $conn->Parametro("@cliente", $cliente);
        $conn->Parametro("@observaciones", $observaciones);
        $data = $conn->Procedimiento("dbo.PA_SOLO_CLIENTE");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarZonasMesa($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarZonasMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCategorias_PorAbreviatura($abrevitura)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@abreviatura", $abrevitura);
        $data = $conn->Procedimiento("dbo.PA_ListarCategorias_PorAbreviatura");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCategorias()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarCategorias");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulosxCategoria_Programacion($categoria)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Categoria", $categoria);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulosxCategoria_Programacion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPermisosWeb_PorUsuario($codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarPermisosWeb_PorUsuario");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerEstadoSeEstaCobrando_PorCodigo($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerEstadoSeEstaCobrando_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_EstadoCaja_xCodigo_WEB($CD_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CD_Codigo", $CD_Codigo);
        $data = $conn->Procedimiento("dbo.PA_EstadoCaja_xCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarIngresosDineroEntreFechasXCaja($Inicio, $Final, $Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarIngresoDinero");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ListarIngresosDineroWEB($Inicio, $Final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $data = $conn->Procedimiento("dbo.PA_ListarIngresoDineroWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarSalidasDineroEntreFechasxCaja($Inicio, $Final, $Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinak", $Final);
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarSalidasDineroEntreFechasxCaja");
        $conn->Desconectar();
        return json_encode($data);
	}
		public function PA_ListarEgresosDineroWEB($Inicio, $Final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $data = $conn->Procedimiento("dbo.PA_ListarEgresoDineroWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarVentas_WEB($Inicio, $Final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FechaInicio", $Inicio);
        $conn->Parametro("@FechaFinal", $Final);
        $data = $conn->Procedimiento("dbo.PA_ListarVentas_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulos_PorTipo($Tipo, $Descripcion, $Categoria)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Tipo", $Tipo);
        $conn->Parametro("@Descripcion", $Descripcion);
        $conn->Parametro("@Categoria", $Categoria);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulos_PorTipo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarInsumos_WEB($descripcion, $categoria, $tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", $descripcion);
        $conn->Parametro("@cat", $categoria);
        $conn->Parametro("@tipo", $tipo);
        $data = $conn->Procedimiento("dbo.PA_ListarInsumos_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCategorias_PorTipoWEB($Tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Tipo", $Tipo);
        $data = $conn->Procedimiento("dbo.PA_ListarCategorias_PorTipoWEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarBebidasStockMinimo()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", "Habilitado");
        $data = $conn->Procedimiento("dbo.PA_ListarBebidasStockMinimo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarInsumosStockMinimo()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Estado", "Habilitado");
        $data = $conn->Procedimiento("dbo.PA_ListarInsumosStockMinimo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCajasxFecha($inicio, $final)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@fechaInicio", $inicio);
        $conn->Parametro("@fechaFinal", $final);
        $data = $conn->Procedimiento("dbo.PA_ListarCajasxFecha");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_BuscarFormulario_PorCliente_WEB($FDM_NombreCliente, $FDM_Tipo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FDM_NombreCliente", $FDM_NombreCliente);
        $conn->Parametro("@FDM_Tipo", $FDM_Tipo);
        $data = $conn->Procedimiento("dbo.PA_BuscarFormulario_PorCliente_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerPedido_PorCodigo_WEB($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPedido_PorCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerIngreso_PorCodigo($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@VEN_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerIngreso_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	public function PA_ObtenerDetalleVentaWeb_PorCodigo($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@VEN_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerDetalleVentaWeb_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerDetallePedido_PorCodigo_WEB($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerDetallePedido_PorCodigo_WEB");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerFormularioDeliveryMostrador_PorCodigo($FDM_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@FDM_Codigo", $FDM_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerFormularioDeliveryMostrador_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarFormularioDeliveryMostrador($obj){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@FDM_Codigo", $obj['FDM_Codigo']);
        $conn->Parametro("@FDM_Tipo", $obj['FDM_Tipo']);
        $conn->Parametro("@FDM_Estado", $obj['FDM_Estado']);
        $conn->Parametro("@FDM_NombreCliente", $obj['FDM_NombreCliente']);
        $conn->Parametro("@FDM_Celular", $obj['FDM_Celular']);
        $data = $conn->Procedimiento("dbo.PA_InsertarFormularioDeliveryMostrador");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok', 'datos'=>$data];
        return json_encode($data);
	}
	
	public function PA_ListarCajaxCodigo($Codigo){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarCajaxCodigo");  
        
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_CajaDinero_WEB($SaldoInicial, $CodigoPersonal, $Almacen, $Tipo, $xCD, $Ingresos, $Egresos, $SaldoActual, $Retiro, $SaldoFinal){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@SaldoInicial", $SaldoInicial);
        $conn->Parametro("@CodigoPersonal", $CodigoPersonal);
        $conn->Parametro("@Almacen", $Almacen);
        $conn->Parametro("@Tipo", $Tipo);
        $conn->Parametro("@xCD", $xCD);
        $conn->Parametro("@Ingresos", $Ingresos);
        $conn->Parametro("@Egresos", $Egresos);
        $conn->Parametro("@SaldoActual", $SaldoActual);
        $conn->Parametro("@Retiro", $Retiro);
        $conn->Parametro("@SaldoFinal", $SaldoFinal);
        $data = $conn->Procedimiento("dbo.PA_CajaDinero_WEB");  
        
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB1($CodigoCaja){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@CD_Codigo", $CodigoCaja);
        $data = $conn->Procedimiento("dbo.PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB1");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB2($CodigoCaja){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@CD_Codigo", $CodigoCaja);
        $data = $conn->Procedimiento("dbo.PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB2");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarFormaPago(){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ListarFormaPago");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_IngresoDinero_WEB($Obj){
        try{
            $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@ID_Codigo", $Obj['Codigo']);
            $conn->Parametro("@ID_Fecha", $Obj['Fecha']);
            $conn->Parametro("@ID_Monto", $Obj['Importe']);
            $conn->Parametro("@ID_Concepto", $Obj['Observacion']);
            $conn->Parametro("@CON_Codigo", $Obj['idconcepto']);
            $conn->Parametro("@PER_Codigo", $Obj['PER_Codigo']);
            $conn->Parametro("@Tipo", $Obj['Tipo']);
            $data = $conn->Procedimiento("dbo.PA_IngresoDinero_WEB");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Rpta = $data[0]['Rpta'];
            $Codigo = $data[0]['CodigoGenerado'];
            
            $data = ['Rpta' => $Rpta, 'CodigoGenerado' => $Codigo];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['Rpta'=>'error'.$ex->getMessage()];
            return json_encode($data);
	    }
	}
	
	public function PA_ObtenerIngresoDinero_WEB($id){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@ID_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerIngresoDinero_WEB");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerSalidaDinero_WEB($id){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@SAL_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerSalidaDinero_WEB");  
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_SalidaDinero_WEB($Obj){
        try{
            $conn = new Conexion();
            $conn->Conectar();
            $conn->reiniciarArray();
            $conn->Parametro("@SAL_Codigo", $Obj['Codigo']);
            $conn->Parametro("@SAL_Fecha", $Obj['Fecha']);
            $conn->Parametro("@SAL_Destinatario", $Obj['Se単or']);
            $conn->Parametro("@SAL_Monto", $Obj['Importe']);
            $conn->Parametro("@SAL_Concepto", $Obj['Observacion']);
            $conn->Parametro("@CON_Codigo", $Obj['idconcepto']);
            $conn->Parametro("@PER_Codigo", $Obj['PER_Codigo']);
            $conn->Parametro("@Tipo", $Obj['Tipo']);
            $data = $conn->Procedimiento("dbo.PA_SalidaDinero_WEB");  
            $data = json_decode(json_encode($data), true);
            $conn->Desconectar();
            
            $Rpta = $data[0]['Rpta'];
            $Codigo = $data[0]['CodigoGenerado'];
            
            $data = ['Rpta' => $Rpta, 'CodigoGenerado' => $Codigo];
            return json_encode($data);
	    }
	    catch(Exception $ex){
	        $data = ['Rpta'=>'error'.$ex->getMessage()];
            return json_encode($data);
	    }
	}
	
	
	
	public function PA_ObtenerVenta_PorCodigo($VEN_Codigo){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@VEN_Codigo", $VEN_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerVenta_PorCodigo");  
        $conn->Desconectar();
        
        $datatable1 = $data;
        
        
        $conn->Conectar();
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ObtenerLogoEmpresa");  
        $conn->Desconectar();
        
        $datatable2 = $data;
        
        $DataSet = [
            'datatable1' => $datatable1,
            'datatable2' => $datatable2
        ];
        
        return json_encode($DataSet);
	}
	
	public function PA_ObtenerLogoEmpresa(){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ObtenerLogoEmpresa");  
        $conn->Desconectar();
        
        $datatable2 = $data;
        return json_encode($data);
	}
	
    public function PA_ListarProveedores(){
        try {
            $conn = new Conexion();
            $conn->Conectar();
            $conn->Parametro("@Descripcion", "%");
            $conn->Parametro("@Ruc", "");
            $conn->Parametro("@Tipo", 1);
            $data = $conn->Procedimiento("dbo.PA_ListarProveedores");  
            $conn->Desconectar();
            
            if (empty($data)) {
                return json_encode(['error' => 'No hay datos', 'procedimiento' => 'PA_ListarProveedores']);
            }
            
            return json_encode($data ?: []);
        } catch (Exception $e) {
            return json_encode(['error' => $e->getMessage()]);
        }
    }
    
    public function PA_ListarProveedorxRUC($ruc){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", "");
        $conn->Parametro("@Ruc", "%" . $ruc . "%");
        $conn->Parametro("@Tipo", 2);
        $data = $conn->Procedimiento("dbo.PA_ListarProveedores");  
        $conn->Desconectar();
        return json_encode($data ?: []);
	}
	
	public function PA_ListarProveedorxRazonSocial($razonSocial){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Descripcion", "%" . $razonSocial . "%");
        $conn->Parametro("@Ruc", "");
        $conn->Parametro("@Tipo", 1);
        $data = $conn->Procedimiento("dbo.PA_ListarProveedores");  
        $conn->Desconectar();
        return json_encode($data ?: []);
	}
	
	public function ObtenerSiguienteCodigoProveedor(){
        $conn = new Conexion();
        $conn->Conectar();
        $query = "SELECT ISNULL(RIGHT('000000' + CAST(MAX(CAST(PRO_Codigo AS INT)) + 1 AS VARCHAR), 6), '000001') AS SiguienteCodigo FROM Proveedores";
        $data = $conn->Consulta($query);
		$conn->Desconectar();
		$siguiente = (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo'])
			? $data[0]['SiguienteCodigo']
			: '000001';
		return $siguiente;
    }
    	
    public function PA_InsertarProveedor($proveedor, $nuevoCodigo)
    {
        try {
            $conn = new Conexion();
            $conn->Conectar();
    
            $conn->Parametro("@Codigo", $nuevoCodigo);
            $conn->Parametro("@Ruc", $proveedor['PRO_Ruc']);
            $conn->Parametro("@Denominacion", $proveedor['PRO_Denominacion']);
            $conn->Parametro("@RazonSocial", $proveedor['PRO_RazonSocial']);
            $conn->Parametro("@Direccion", $proveedor['PRO_Direccion']);
            $conn->Parametro("@DireccionSecundaria", $proveedor['PRO_DireccionSecundaria']);
            $conn->Parametro("@Email", $proveedor['PRO_Email']);
            $conn->Parametro("@Web", $proveedor['PRO_Web']);
            $conn->Parametro("@Estado", 'Habilitado');
            $conn->Parametro("@CodigoAlmacen", '000001');
            $conn->Parametro("@Tipo", 1);
    
            $conn->Procedimiento("dbo.PA_Proveedores");
            $conn->Desconectar();
    
            return json_encode([
                'success' => true,
                'NuevoCodigo' => $nuevoCodigo
            ]);
    
        } catch (Exception $e) {
            error_log('Error en PA_InsertarProveedor: ' . $e->getMessage());
            return json_encode([
                'error' => 'Error al insertar proveedor: ' . $e->getMessage()
            ]);
        }
    }
    
    public function PA_InsertarContactoProveedor($contacto) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $contacto['PROV_Codigo']);
        $conn->Parametro("@CodigoDetalle", '');
        $conn->Parametro("@DNI", $contacto['DC_DNI']);
        $conn->Parametro("@Nombres", $contacto['DC_Nombres']);
        $conn->Parametro("@Direccion", $contacto['DC_Direccion']);
        $conn->Parametro("@Telefono", $contacto['DC_Telefono']);
        $conn->Parametro("@Email", $contacto['DC_Email']);
        $conn->Parametro("@Cargo", $contacto['DC_Cargo']);
        $conn->Parametro("@Tipo", 1);
        $conn->Procedimiento("dbo.PA_DetalleContactos");
        $conn->Desconectar();
    }
    
    public function PA_ActualizarContactoProveedor($contacto){
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $contacto['PROV_Codigo']);
        $conn->Parametro("@CodigoDetalle", $contacto['DC_Codigo']);
        $conn->Parametro("@DNI", $contacto['DC_DNI']);
        $conn->Parametro("@Nombres", $contacto['DC_Nombres']);
        $conn->Parametro("@Direccion", $contacto['DC_Direccion']);
        $conn->Parametro("@Telefono", $contacto['DC_Telefono']);
        $conn->Parametro("@Email", $contacto['DC_Email']);
        $conn->Parametro("@Cargo", $contacto['DC_Cargo']);
        $conn->Parametro("@Tipo", 3);
        $conn->Procedimiento("dbo.PA_DetalleContactos");
        $conn->Desconectar();
    }
    
    public function PA_EliminarContactoProveedor($contacto){
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $contacto['PROV_Codigo']);
        $conn->Parametro("@CodigoDetalle", $contacto['DC_Codigo']);
        $conn->Parametro("@DNI", '');
        $conn->Parametro("@Nombres", '');
        $conn->Parametro("@Direccion", '');
        $conn->Parametro("@Telefono", '');
        $conn->Parametro("@Email", '');
        $conn->Parametro("@Cargo", '');
        $conn->Parametro("@Tipo", 2);
        $conn->Procedimiento("dbo.PA_DetalleContactos");
        $conn->Desconectar();
    }
    
    public function PA_ListarContactosProveedor($codigo) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarDetalleContactoxCodigo");
        $conn->Desconectar();
    
        if (empty($data)) {
            return json_encode(['error' => 'No hay contactos', 'procedimiento' => 'PA_ListarDetalleContactoxCodigo']);
        }
    
        return json_encode($data ?: []);
    }
    
    public function PA_ListarTelefonosProveedor($codigo) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@TipoFormulario", 'PROVEEDOR');
        $conn->Parametro("@Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_DetalleTelefonoxCodigo");
        $conn->Desconectar();
    
        if (empty($data)) {
            return json_encode([
                'error' => 'No hay teléfonos registrados',
                'procedimiento' => 'PA_DetalleTelefonoxCodigo'
            ]);
        }
    
        return json_encode($data ?: []);
    }

    public function PA_ListarCuentasProveedor($codigo) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_DetalleCuentasxCodigo");
        $conn->Desconectar();
    
        if (empty($data)) {
            return json_encode([
                'error' => 'No hay cuentas registradas',
                'procedimiento' => 'PA_DetalleCuentasxCodigo'
            ]);
        }
    
        return json_encode($data ?: []);
    }
    
    public function PA_ActualizarProveedor($proveedor)
    {
        try {
            $conn = new Conexion();
            $conn->Conectar();
            $conn->Parametro("@Codigo", $proveedor['PRO_Codigo']);
            $conn->Parametro("@Ruc", $proveedor['PRO_Ruc']);
            $conn->Parametro("@Denominacion", $proveedor['PRO_Denominacion']);
            $conn->Parametro("@RazonSocial", $proveedor['PRO_RazonSocial']);
            $conn->Parametro("@Direccion", $proveedor['PRO_Direccion']);
            $conn->Parametro("@DireccionSecundaria", $proveedor['PRO_DireccionSecundaria']);
            $conn->Parametro("@Email", $proveedor['PRO_Email']);
            $conn->Parametro("@Web", $proveedor['PRO_Web']);
            $conn->Parametro("@Estado", $proveedor['PRO_Estado']);
            $conn->Parametro("@CodigoAlmacen", '000001');
            $conn->Parametro("@Tipo", 2); 
            $conn->Procedimiento("dbo.PA_Proveedores");
            $conn->Desconectar();
    
            return json_encode(['success' => true, 'message' => 'Proveedor actualizado correctamente']);
        } catch (Exception $e) {
            error_log('Error en PA_ActualizarProveedor: ' . $e->getMessage());
            return json_encode(['error' => $e->getMessage()]);
        }
    }
    
    public function PA_ObtenerProveedor($codigo)
    {
        try {
            $conn = new Conexion();
            $conn->Conectar();
            $conn->Parametro("@Codigo", $codigo);
            $data = $conn->Procedimiento("dbo.PA_ObtenerProveedor");
            $conn->Desconectar();
    
            if (empty($data)) {
                return json_encode(['error' => 'Proveedor no encontrado']);
            }
    
            return json_encode($data[0]);
        } catch (Exception $e) {
            return json_encode(['error' => $e->getMessage()]);
        }
    }

    public function PA_EliminarProveedor($codigo)
    {
        try {
            $conn = new Conexion();
            $conn->Conectar();
            $conn->Parametro("@Codigo", $codigo);
            $conn->Parametro("@Ruc", '');
            $conn->Parametro("@Denominacion", '');
            $conn->Parametro("@RazonSocial", '');
            $conn->Parametro("@Direccion", '');
            $conn->Parametro("@DireccionSecundaria", '');
            $conn->Parametro("@Email", '');
            $conn->Parametro("@Web", '');
            $conn->Parametro("@Estado", 'Deshabilitado');
            $conn->Parametro("@CodigoAlmacen", '000001');
            $conn->Parametro("@Tipo", 3);
    
            $conn->Procedimiento("dbo.PA_Proveedores");
            $conn->Desconectar();
    
            return json_encode(['success' => true, 'mensaje' => 'Proveedor eliminado correctamente']);
        } catch (Exception $e) {
            return json_encode(['error' => $e->getMessage()]);
        }
    }
    
    public function PA_ListarTipoOperador($Descripcion) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Descripcion", "%".$Descripcion."%");
        $data = $conn->Procedimiento("dbo.PA_ListarTipoOperadorxDescripcion");  
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_ListarTipoTelefono($Descripcion) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Descripcion", "%".$Descripcion."%");
        $data = $conn->Procedimiento("dbo.PA_ListarTipoTelefonoxDescripcion");  
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_InsertarTelefonoProveedor($telefono) { 
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@TipoFormulario", 'PROVEEDOR');
        $conn->Parametro("@Codigo", $telefono['PROV_Codigo']);
        $conn->Parametro("@CodTipoOperador", $telefono['TO_Codigo']);
        $conn->Parametro("@CodTipoTelefono", $telefono['TT_Codigo']);
        $conn->Parametro("@Numero", $telefono['DT_Numero']);
        $conn->Parametro("@Tipo", 1);
        $conn->Procedimiento("dbo.PA_DetalleTelefono");
        $conn->Desconectar();
    }
    
    public function PA_DetalleTelefono_Eliminar($detalle) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@TipoFormulario", 'PROVEEDOR');
        $conn->Parametro("@Codigo", $detalle['PROV_Codigo']);
        $conn->Parametro("@CodTipoOperador", $detalle['TO_Codigo']);
        $conn->Parametro("@CodTipoTelefono", $detalle['TT_Codigo']);
        $conn->Parametro("@Numero", '');
        $conn->Parametro("@Tipo", 2);
        $conn->Procedimiento("dbo.PA_DetalleTelefono");
        $conn->Desconectar();
    }
    
    public function PA_ListarEntidadesFinancieras($Descripcion) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Descripcion", "%".$Descripcion."%");
        $data = $conn->Procedimiento("dbo.PA_ListarEntidadesxDescripcion");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_ListarTiposCuenta($Descripcion, $EF_Codigo = '')
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Descripcion", "%" . $Descripcion . "%");
        $conn->Parametro("@EF_Codigo", $EF_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarCuentasxDescripcion");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_InsertarCuentaProveedor($cuenta) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $cuenta['PROV_Codigo']);
        $conn->Parametro("@CodTipoCuenta", $cuenta['TC_Codigo']);
        $conn->Parametro("@Numero", $cuenta['DC_NroCuenta']);
        $conn->Parametro("@Tipo", 1);
        $conn->Procedimiento("dbo.PA_DetalleCuentas");
        $conn->Desconectar();
    }
    
    public function PA_DetalleCuentas_Eliminar($detalle) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $detalle['PROV_Codigo']);
        $conn->Parametro("@CodTipoCuenta", '');
        $conn->Parametro("@Numero", '');
        $conn->Parametro("@Tipo", 2);
        $conn->Procedimiento("dbo.PA_DetalleCuentas");
        $conn->Desconectar();
    }
    
    public function PA_ListarCondicion($Estado){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Estado", $Estado);
        $data = $conn->Procedimiento("dbo.PA_ListarCondicion");  
        
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarAreas($Estado){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Estado", $Estado);
        $data = $conn->Procedimiento("dbo.PA_ListaAreas");  
        
        $conn->Desconectar();
        return json_encode($data);
	}

	public function PA_ListarCargos($Estado){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Estado", $Estado);
        $data = $conn->Procedimiento("dbo.PA_ListarCargos");  
        
        $conn->Desconectar();
        return json_encode($data);
	}

    public function PA_Personal($obj) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
    
        $conn->Parametro("@Codigo", $obj['Codigo']);
        $conn->Parametro("@DNI", $obj['DNI']);
        $conn->Parametro("@Apellidos", $obj['Apellidos']);
        $conn->Parametro("@Nombres", $obj['Nombres']);
        $conn->Parametro("@Sexo", $obj['Sexo']);
        $conn->Parametro("@Direccion", $obj['Direccion']);
        $conn->Parametro("@FechaNacimiento", $obj['FechaNacimiento']);
        $conn->Parametro("@FechaContratacion", $obj['FechaContratacion']);
        $conn->Parametro("@Telefono", $obj['Telefono']);
        $conn->Parametro("@Estado", $obj['Estado']);
        $conn->Parametro("@CodCondicion", $obj['CodCondicion']);
        $conn->Parametro("@CodArea", $obj['CodArea']);
        $conn->Parametro("@CodCargo", $obj['CodCargo']);
        $conn->Parametro("@Ciudad", $obj['Ciudad']);
        $conn->Parametro("@CodVenta", $obj['CodVenta']);
        $conn->Parametro("@Tipo", $obj['Tipo']);
    
        $result = $conn->Procedimiento("dbo.PA_Personal");  
        $conn->Desconectar();
    
        return json_encode($result);
    }

	public function PA_ListarPersonalXCodigo($Codigo){
		$conn = new Conexion();
		$conn->Conectar();
		$conn->reiniciarArray();

		$conn->Parametro("@Codigo", $Codigo);

		$result = $conn->Procedimiento("dbo.PA_ListarPersonalXCodigo");  
		$conn->Desconectar();

		return json_encode($result);
	}
	
	public function PA_ListarCodigosPersonal(){
		$conn = new Conexion();
		$conn->Conectar();
		$conn->reiniciarArray();

		$result = $conn->Procedimiento("dbo.PA_ListarCodigosPersonal");  
		$conn->Desconectar();

		return json_encode($result);
	}
	
	public function PA_ListarClientes()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarClientes");
        $conn->Desconectar();
        return json_encode($data ?: []);
    }

    public function PA_ListarClientes_PorDescripcion($razonSocial)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@RazonSocial", $razonSocial);
        $data = $conn->Procedimiento("dbo.PA_ListarClientes_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data ?: []);
    }

    public function PA_ListarClientes_PorDNIRUC($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarClientesxruc2");
        $conn->Desconectar();
        return json_encode($data ?: []);
    }

    public function PA_ListarClientes_PorCondicion($condicion)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Condicion", $condicion);
        $data = $conn->Procedimiento("dbo.PA_ListarClientesxCondicion");
        $conn->Desconectar();
        return json_encode($data ?: []);
    }

    public function ObtenerSiguienteCodigoCliente()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $query = "SELECT ISNULL(RIGHT('000000' + CAST(MAX(CAST(CLI_DNIRUC AS INT)) + 1 AS VARCHAR), 6), '000001') AS SiguienteCodigo FROM Cliente";
        $data = $conn->Consulta($query);
        $conn->Desconectar();
        return (isset($data[0]['SiguienteCodigo']) ? $data[0]['SiguienteCodigo'] : '000001');
    }

    public function PA_InsertarCliente($cliente, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();

        $conn->Parametro("@DNIRUC", $nuevoCodigo); 
        $conn->Parametro("@Codigo", $cliente['CLI_Codigo']); 
        $conn->Parametro("@TipoCliente", $cliente['CLI_Tipo']);
        $conn->Parametro("@RazonSocial", $cliente['CLI_RazonSocial']);
        $conn->Parametro("@Denominacion", $cliente['CLI_Denominacion']);
        $conn->Parametro("@Email", $cliente['CLI_Email']);
        $conn->Parametro("@Telefono", $cliente['CLI_Telefono']);
        $conn->Parametro("@Direccion", $cliente['CLI_Direccion']);
        $conn->Parametro("@Estado", 'Habilitado');
        $conn->Parametro("@Marca", $cliente['CLI_Marca']);
        $conn->Parametro("@Modelo", $cliente['CLI_Modelo']);
        $conn->Parametro("@Vehiculo", $cliente['CLI_Vehiculo']);
        $conn->Parametro("@Ciudad", $cliente['CLI_Ciudad']);
        $conn->Parametro("@Condicion", $cliente['CLI_Condicion']);
        $conn->Parametro("@Tipo", 1);

        $conn->Procedimiento("dbo.PA_Cliente");
        $conn->Desconectar();

        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
    }

    public function PA_ActualizarCliente($cliente)
    {
        $conn = new Conexion();
        $conn->Conectar();

        $conn->Parametro("@DNIRUC", $cliente['CLI_DNIRUC']);
        $conn->Parametro("@Codigo", $cliente['CLI_Codigo']);
        $conn->Parametro("@TipoCliente", $cliente['CLI_Tipo']);
        $conn->Parametro("@RazonSocial", $cliente['CLI_RazonSocial']);
        $conn->Parametro("@Denominacion", $cliente['CLI_Denominacion']);
        $conn->Parametro("@Email", $cliente['CLI_Email']);
        $conn->Parametro("@Telefono", $cliente['CLI_Telefono']);
        $conn->Parametro("@Direccion", $cliente['CLI_Direccion']);
        $conn->Parametro("@Estado", $cliente['CLI_Estado']);
        $conn->Parametro("@Marca", $cliente['CLI_Marca']);
        $conn->Parametro("@Modelo", $cliente['CLI_Modelo']);
        $conn->Parametro("@Vehiculo", $cliente['CLI_Vehiculo']);
        $conn->Parametro("@Ciudad", $cliente['CLI_Ciudad']);
        $conn->Parametro("@Condicion", $cliente['CLI_Condicion']);
        $conn->Parametro("@Tipo", 2);

        $conn->Procedimiento("dbo.PA_Cliente");
        $conn->Desconectar();

        return json_encode(['success' => true, 'message' => 'Cliente actualizado correctamente']);
    }

    public function PA_EliminarCliente($cliente)
    {
        $conn = new Conexion();
        $conn->Conectar();

        $conn->Parametro("@DNIRUC", $cliente['CLI_DNIRUC']);
        $conn->Parametro("@Codigo", $cliente['CLI_Codigo']);
        $conn->Parametro("@TipoCliente", '');
        $conn->Parametro("@RazonSocial", '');
        $conn->Parametro("@Denominacion", '');
        $conn->Parametro("@Email", '');
        $conn->Parametro("@Telefono", '');
        $conn->Parametro("@Direccion", '');
        $conn->Parametro("@Estado", 'Eliminado');
        $conn->Parametro("@Marca", '');
        $conn->Parametro("@Modelo", '');
        $conn->Parametro("@Vehiculo", '');
        $conn->Parametro("@Ciudad", '');
        $conn->Parametro("@Condicion", '');
        $conn->Parametro("@Tipo", 3);

        $conn->Procedimiento("dbo.PA_Cliente");
        $conn->Desconectar();

        return json_encode(['success' => true, 'message' => 'Cliente eliminado correctamente']);
    }

    public function PA_ObtenerCliente($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@cli_id", $codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerCliente_PorCodigo");
        $conn->Desconectar();

        return !empty($data)
            ? json_encode($data[0])
            : json_encode(['error' => 'Cliente no encontrado']);
    }
    
    public function PA_ListarUsuarios($Estado) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Estado", $Estado);
        $data = $conn->Procedimiento("dbo.PA_ListarUsuarios");  
        
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_ListarUsuariosxNombres($Nombres) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@nombres", $Nombres);
        $data = $conn->Procedimiento("dbo.PA_ListarUsuariosxNombres");  
        
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_ListarUsuarioxCodigo($Codigo) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $Codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarUsuarioxCodigo");  
        
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_Usuario($obj)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $obj['Codigo']);
        $conn->Parametro("@Nick", $obj['Nick']);
        $conn->Parametro("@Contraseña", $obj['Contraseña']);
        $conn->Parametro("@Estado", $obj['Estado']);
        $conn->Parametro("@Tipo", $obj['Tipo']);
        $conn->Parametro("@rol_id", $obj['rol_id']); 
        $result = $conn->Procedimiento("dbo.PA_Usuario");  
        $conn->Desconectar();
        return json_encode($result);
    }
    
    public function PA_Usuario_ModificarNick($obj) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
    
        $conn->Parametro("@Codigo", $obj['Codigo']);
        $conn->Parametro("@Nick", $obj['Nick']);
    
        $result = $conn->Procedimiento("dbo.PA_Usuario_ModificarNick");  
        $conn->Desconectar();
    
        return json_encode($result);
    }
    
    public function PA_Usuario_ModificarOpciones($obj) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
    
        $conn->Parametro("@Codigo", $obj['Codigo']);
        $conn->Parametro("@VerCosto", $obj['VerCosto']);
        $conn->Parametro("@Clave", $obj['Clave']);
        $conn->Parametro("@ModificaPrecios", $obj['ModificaPrecios']);
    
        $result = $conn->Procedimiento("dbo.PA_Usuario_ModificarOpciones");  
        $conn->Desconectar();
    
        return json_encode($result);
    }
    
    public function PA_Usuario_ModificarContraseña($obj) {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
    
        $conn->Parametro("@Codigo", $obj['Codigo']);
        $conn->Parametro("@Contraseña", $obj['Contraseña']);
    
        $result = $conn->Procedimiento("dbo.PA_Usuario_ModificarContraseña");  
        $conn->Desconectar();
    
        return json_encode($result);
    }

    public function ObtenerSiguienteCodigoCargo()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $query = "SELECT ISNULL(RIGHT('000000' + CAST(MAX(CAST(CAR_Codigo AS INT)) + 1 AS VARCHAR), 6), '000001') AS SiguienteCodigo FROM Cargo";
        $data = $conn->Consulta($query);
        $conn->Desconectar();

        $siguiente = '000001';
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }

    public function PA_InsertarCargo($cargo, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $nuevoCodigo);
        $conn->Parametro("@Descripcion", $cargo['CAR_Descripcion']);
        $conn->Parametro("@Estado", 'Habilitado');
        $conn->Parametro("@Tipo", 1);
    
        $conn->Procedimiento("dbo.PA_Cargo");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
    }
    
    public function PA_ActualizarCargo($cargo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $cargo['CAR_Codigo']);
        $conn->Parametro("@Descripcion", $cargo['CAR_Descripcion']);
        $conn->Parametro("@Estado", $cargo['CAR_Estado']);
        $conn->Parametro("@Tipo", 2);
    
        $conn->Procedimiento("dbo.PA_Cargo");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Cargo actualizado correctamente']);
    }
    
    public function PA_EliminarCargo($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $codigo);
        $conn->Parametro("@Descripcion", '');
        $conn->Parametro("@Estado", 'Eliminado');
        $conn->Parametro("@Tipo", 3);
    
        $conn->Procedimiento("dbo.PA_Cargo");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Cargo eliminado correctamente']);
    }
    
    public function ObtenerSiguienteCodigoArea()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $query = "
            SELECT ISNULL(
                RIGHT('000000' + CAST(MAX(CAST(AREA_Codigo AS INT)) + 1 AS VARCHAR), 6),
                '000001'
            ) AS SiguienteCodigo
            FROM Area
        ";
    
        $data = $conn->Consulta($query);
        $conn->Desconectar();
    
        $siguiente = '000001';
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }
    
    public function PA_InsertarArea($area, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $nuevoCodigo);
        $conn->Parametro("@Descripcion", $area['AREA_Descripcion']);
        $conn->Parametro("@Estado",      isset($area['AREA_Estado']) ? $area['AREA_Estado'] : 'Habilitado');
        $conn->Parametro("@Tipo",        1);
    
        $conn->Procedimiento("dbo.PA_Area");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo, 'message' => 'Área registrada correctamente.']);
    }
    
    public function PA_ActualizarArea($area)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $area['AREA_Codigo']);
        $conn->Parametro("@Descripcion", $area['AREA_Descripcion']);
        $conn->Parametro("@Estado",      $area['AREA_Estado']); 
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_Area");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Área actualizada correctamente']);
    }
    
    public function PA_EliminarArea($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $codigo);
        $conn->Parametro("@Descripcion", '');   
        $conn->Parametro("@Estado",      'Eliminado');    
        $conn->Parametro("@Tipo",        3);              
    
        $conn->Procedimiento("dbo.PA_Area");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Área eliminada correctamente']);
    }
    
    public function ObtenerSiguienteCodigoCondicionLaboral()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $query = "
            SELECT ISNULL(
                RIGHT('000000' + CAST(MAX(CAST(CON_Codigo AS INT)) + 1 AS VARCHAR), 6),
                '000001'
            ) AS SiguienteCodigo
            FROM Condicion_Laboral
        ";
        $data = $conn->Consulta($query);
        $conn->Desconectar();
    
        $siguiente = '000001';
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }

    public function PA_InsertarCondicionLaboral($condicion, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $nuevoCodigo);
        $conn->Parametro("@Descripcion", $condicion['CON_Descripcion']);
        $conn->Parametro("@Estado", 'Habilitado');
        $conn->Parametro("@Tipo", 1);
    
        $conn->Procedimiento("dbo.PA_CondicionLaboral");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
    }
    
    public function PA_ActualizarCondicionLaboral($condicion)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $condicion['CON_Codigo']);
        $conn->Parametro("@Descripcion", $condicion['CON_Descripcion']);
        $conn->Parametro("@Estado", $condicion['CON_Estado']);
        $conn->Parametro("@Tipo", 2);
    
        $conn->Procedimiento("dbo.PA_CondicionLaboral");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Condición laboral actualizada correctamente']);
    }
    
    public function PA_EliminarCondicionLaboral($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $codigo);
        $conn->Parametro("@Descripcion", '');  
        $conn->Parametro("@Estado", 'Eliminado'); 
        $conn->Parametro("@Tipo", 3);
    
        $conn->Procedimiento("dbo.PA_CondicionLaboral");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Condición laboral eliminada correctamente']);
    }
    
    public function ObtenerSiguienteCodigoTipoOrden()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $query = "
            SELECT ISNULL(
                RIGHT('000000' + CAST(MAX(CAST(TOO_Codigo AS INT)) + 1 AS VARCHAR), 6),
                '000001'
            ) AS SiguienteCodigo
            FROM TipoOrden
        ";
        $data = $conn->Consulta($query);
        $conn->Desconectar();
    
        $siguiente = '000001';
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }
    
    public function PA_InsertarTipoOrden($tipoOrden, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $nuevoCodigo);
        $conn->Parametro("@Descripcion", $tipoOrden['TOO_Descripcion']);
        $conn->Parametro("@Estado",      'Habilitado');
        $conn->Parametro("@Tipo",        1);
    
        $conn->Procedimiento("dbo.PA_TipoOrden");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
    }
    
    public function PA_ActualizarTipoOrden($tipoOrden)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $tipoOrden['TOO_Codigo']);
        $conn->Parametro("@Descripcion", $tipoOrden['TOO_Descripcion']);
        $conn->Parametro("@Estado",      $tipoOrden['TOO_Estado']);
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_TipoOrden");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de orden actualizado correctamente']);
    }
    
    public function PA_EliminarTipoOrden($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $codigo);
        $conn->Parametro("@Descripcion", '');       
        $conn->Parametro("@Estado",      'Eliminado'); 
        $conn->Parametro("@Tipo",        3);
    
        $conn->Procedimiento("dbo.PA_TipoOrden");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de orden eliminado correctamente']);
    }
    
    public function PA_ListarTipoOrden($Estado)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Estado", $Estado);
        $data = $conn->Procedimiento("dbo.PA_ListaTipoOrden");
    
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function ObtenerSiguienteCodigoCategoria()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $query = "SELECT ISNULL(RIGHT('000000' + CAST(MAX(CAST(CAT_Codigo AS INT)) + 1 AS VARCHAR), 6), '000001') AS SiguienteCodigo FROM Categorias";
        $data  = $conn->Consulta($query);
    
        $conn->Desconectar();
    
        $siguiente = '000001';
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }
    
    public function PA_InsertarCategoria($categoria, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",       $nuevoCodigo);
        $conn->Parametro("@Nombre",       $categoria['CAT_Nombre']);
        $conn->Parametro("@Estado",       'Habilitado');
        $conn->Parametro("@Abreviatura",  $categoria['CAT_Abreviatura']);
        $conn->Parametro("@Tipo",         1);
    
        $conn->Procedimiento("dbo.PA_Categoria");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
    }
    
    public function PA_ActualizarCategoria($categoria)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",       $categoria['CAT_Codigo']);
        $conn->Parametro("@Nombre",       $categoria['CAT_Nombre']);
        $conn->Parametro("@Estado",       $categoria['CAT_Estado']);
        $conn->Parametro("@Abreviatura",  $categoria['CAT_Abreviatura']);
        $conn->Parametro("@Tipo",         2);
    
        $conn->Procedimiento("dbo.PA_Categoria");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Categoría actualizada correctamente']);
    }
    
    public function PA_EliminarCategoria($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();

        $conn->Parametro("@Codigo",       $codigo);
        $conn->Parametro("@Nombre",       '');             
        $conn->Parametro("@Estado",       'Eliminado');     
        $conn->Parametro("@Abreviatura",  '');             
        $conn->Parametro("@Tipo",         3);
    
        $conn->Procedimiento("dbo.PA_Categoria");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Categoría eliminada correctamente']);
    }
    

    public function ObtenerSiguienteCodigoPresentacion()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $query = "SELECT ISNULL(RIGHT('000000' + CAST(MAX(CAST(PRE_Codigo AS INT)) + 1 AS VARCHAR), 6), '000001') AS SiguienteCodigo FROM Presentaciones";
        $data = $conn->Consulta($query);
    
        $conn->Desconectar();
    
        $siguiente = '000001';
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }
    
    public function PA_InsertarPresentacion($presentacion, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $nuevoCodigo);
        $conn->Parametro("@Descripcion", $presentacion['PRE_Descripcion']);
        $conn->Parametro("@Estado", 'Habilitado');
        $conn->Parametro("@Tipo", 1);
    
        $conn->Procedimiento("dbo.PA_Presentaciones");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
    }
    
    public function PA_ActualizarPresentacion($presentacion)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $presentacion['PRE_Codigo']);
        $conn->Parametro("@Descripcion", $presentacion['PRE_Descripcion']);
        $conn->Parametro("@Estado", $presentacion['PRE_Estado']);
        $conn->Parametro("@Tipo", 2);
    
        $conn->Procedimiento("dbo.PA_Presentaciones");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Presentación actualizada correctamente']);
    }
    
    public function PA_EliminarPresentacion($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $codigo);
        $conn->Parametro("@Descripcion", '');       
        $conn->Parametro("@Estado", 'Eliminado');   
        $conn->Parametro("@Tipo", 3);
    
        $conn->Procedimiento("dbo.PA_Presentaciones");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Presentación eliminada correctamente']);
    }
    
    public function PA_ListarPresentaciones()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ListarPresentaciones");
    
        $conn->Desconectar();
        return json_encode($data);
    }

    public function ObtenerSiguienteCodigoUnidadMedida()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $query = "SELECT ISNULL(RIGHT('000000' + CAST(MAX(CAST(UNM_Codigo AS INT)) + 1 AS VARCHAR), 6), '000001') AS SiguienteCodigo FROM Unidad_Medida";
        $data = $conn->Consulta($query);
    
        $conn->Desconectar();
    
        $siguiente = '000001';
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }
    
    public function PA_InsertarUnidadMedida($unidad, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",       $nuevoCodigo);
        $conn->Parametro("@Nombre",       $unidad['UNM_Nombre']);
        $conn->Parametro("@Estado",       'Habilitado');
        $conn->Parametro("@Abreviatura",  $unidad['UNM_Abreviatura']);
        $conn->Parametro("@Tipo",         1);
    
        $conn->Procedimiento("dbo.PA_Unidad_Medida");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
    }
    
    public function PA_ActualizarUnidadMedida($unidad)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",       $unidad['UNM_Codigo']);
        $conn->Parametro("@Nombre",       $unidad['UNM_Nombre']);
        $conn->Parametro("@Estado",       $unidad['UNM_Estado']);
        $conn->Parametro("@Abreviatura",  $unidad['UNM_Abreviatura']);
        $conn->Parametro("@Tipo",         2);
    
        $conn->Procedimiento("dbo.PA_Unidad_Medida");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Unidad de Medida actualizada correctamente']);
    }
    
    public function PA_EliminarUnidadMedida($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",       $codigo);
        $conn->Parametro("@Nombre",       "");           
        $conn->Parametro("@Estado",       "Eliminado");   
        $conn->Parametro("@Abreviatura",  "");           
        $conn->Parametro("@Tipo",         3);
    
        $conn->Procedimiento("dbo.PA_Unidad_Medida");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Unidad de Medida eliminada correctamente']);
    }
    
    public function PA_ListarUnidadMedidas()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.[PA_ListarUnidadMedidas ]");
    
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_InsertarEntidadFinanciera($entidad)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", 0);
        $conn->Parametro("@Descripcion", $entidad['EF_Descripcion']);
        $conn->Parametro("@Estado", $entidad['EF_Estado']); 
        $conn->Parametro("@Tipo", 1);
    
        $conn->Procedimiento("dbo.PA_EntidadFinanciera");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Entidad financiera guardada correctamente']);
    }
    
    public function PA_ActualizarEntidadFinanciera($entidad)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $entidad['EF_Codigo']);       
        $conn->Parametro("@Descripcion", $entidad['EF_Descripcion']);
        $conn->Parametro("@Estado",      $entidad['EF_Estado']);     
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_EntidadFinanciera");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Entidad financiera actualizada correctamente']);
    }
    
    public function PA_EliminarEntidadFinanciera($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo", $codigo);
        $conn->Parametro("@Descripcion", "");
        $conn->Parametro("@Estado", "Eliminado");
        $conn->Parametro("@Tipo", 3);
    
        $conn->Procedimiento("dbo.PA_EntidadFinanciera");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Entidad financiera eliminada correctamente']);
    }
    
    public function PA_ListarEntidades($Estado)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
    
        $conn->Parametro("@Estado", $Estado);
        $data = $conn->Procedimiento("dbo.PA_ListarEntidades");
    
        $conn->Desconectar();
        return json_encode($data);
    }

    public function ObtenerSiguienteCodigoFormaPago()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $query = "
            SELECT ISNULL(
                RIGHT('000000' + CAST(MAX(CAST(Codigo AS INT)) + 1 AS VARCHAR), 6),
                '000001'
            ) AS SiguienteCodigo
            FROM TipoPosd
        ";
        $data = $conn->Consulta($query);
    
        $conn->Desconectar();
    
        $siguiente = '000001';
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }
    
    public function PA_InsertarFormaPago($forma, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $nuevoCodigo);
        $conn->Parametro("@Descripcion", $forma['Descripcion']);
        $conn->Parametro("@Tipo",        1);
    
        $conn->Procedimiento("dbo.PA_FormaPago");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
    }
    
    public function PA_ActualizarFormaPago($forma)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $forma['Codigo']);
        $conn->Parametro("@Descripcion", $forma['Descripcion']);
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_FormaPago");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'TipoPosd actualizado correctamente']);
    }
    
    public function PA_EliminarFormaPago($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $codigo);
        $conn->Parametro("@Descripcion", "");
        $conn->Parametro("@Tipo",        3);
    
        $conn->Procedimiento("dbo.PA_FormaPago");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'TipoPosd eliminado correctamente']);
    }
    
    public function PA_InsertarTiposCuenta($tipo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      0);
        $conn->Parametro("@Descripcion", $tipo['TC_Descripcion']);
        $conn->Parametro("@Estado",      'Habilitado');
        $conn->Parametro("@CodEntidad",  $tipo['EF_Codigo']);
        $conn->Parametro("@Tipo",        1);
    
        $conn->Procedimiento("dbo.PA_TiposCuenta");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de cuenta creado correctamente']);
    }
    
    public function PA_ActualizarTiposCuenta($tipo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $tipo['TC_Codigo']);
        $conn->Parametro("@Descripcion", $tipo['TC_Descripcion']);
        $conn->Parametro("@Estado",      $tipo['TC_Estado']);
        $conn->Parametro("@CodEntidad",  $tipo['EF_Codigo']);
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_TiposCuenta");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de cuenta actualizado correctamente']);
    }
    
    public function PA_EliminarTiposCuenta($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $codigo);
        $conn->Parametro("@Descripcion", "");   
        $conn->Parametro("@Estado",      "");   
        $conn->Parametro("@CodEntidad",  0);
        $conn->Parametro("@Tipo",        3);
    
        $conn->Procedimiento("dbo.PA_TiposCuenta");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de cuenta eliminado correctamente']);
    }
    
    public function PA_ListarCuentas()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ListarCuentas");
    
        $conn->Desconectar();
        return json_encode($data);
    }

    
    public function PA_InsertarTiposTelefono($tipo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      0);
        $conn->Parametro("@Descripcion", $tipo['TT_Descripcion']);
        $conn->Parametro("@Estado",      'Habilitado');
        $conn->Parametro("@Tipo",        1);
    
        $conn->Procedimiento("dbo.PA_TiposTelefono");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de teléfono creado correctamente']);
    }
    
    public function PA_ActualizarTiposTelefono($tipo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $tipo['TT_Codigo']);
        $conn->Parametro("@Descripcion", $tipo['TT_Descripcion']);
        $conn->Parametro("@Estado",      $tipo['TT_Estado']);
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_TiposTelefono");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de teléfono actualizado correctamente']);
    }
    
    public function PA_EliminarTiposTelefono($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $codigo);
        $conn->Parametro("@Descripcion", "");   
        $conn->Parametro("@Estado",      "");   
        $conn->Parametro("@Tipo",        3);
    
        $conn->Procedimiento("dbo.PA_TiposTelefono");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de teléfono eliminado correctamente']);
    }
    
    public function PA_ListarTiposTelefono()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ListarTipoTelefono");
    
        $conn->Desconectar();
        return json_encode($data);
    }

    public function PA_InsertarTipoOperador($tipo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      0); 
        $conn->Parametro("@Descripcion", $tipo['TO_Descripcion']);
        $conn->Parametro("@Estado",      'Habilitado');
        $conn->Parametro("@Tipo",        1);
    
        $conn->Procedimiento("dbo.PA_TipoOperador");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de operador creado correctamente']);
    }
    
    public function PA_ActualizarTipoOperador($tipo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $tipo['TO_Codigo']);
        $conn->Parametro("@Descripcion", $tipo['TO_Descripcion']);
        $conn->Parametro("@Estado",      $tipo['TO_Estado']); 
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_TipoOperador");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de operador actualizado correctamente']);
    }
    
    public function PA_EliminarTipoOperador($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $codigo);
        $conn->Parametro("@Descripcion", ""); 
        $conn->Parametro("@Estado",      "");
        $conn->Parametro("@Tipo",        3);
    
        $conn->Procedimiento("dbo.PA_TipoOperador");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Tipo de operador eliminado correctamente']);
    }
    
    public function PA_ListarTiposOperador()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->reiniciarArray();
        $data = $conn->Procedimiento("dbo.PA_ListarTipoOperador"); 
    
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_InsertarConcepto($concepto)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      0); 
        $conn->Parametro("@Descripcion", $concepto['CON_Descripcion']);
        $conn->Parametro("@Tipo",        1);
    
        $conn->Procedimiento("dbo.PA_Conceptos");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Concepto creado correctamente']);
    }
    
    public function PA_ActualizarConcepto($concepto)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $concepto['CON_Codigo']);
        $conn->Parametro("@Descripcion", $concepto['CON_Descripcion']);
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_Conceptos");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Concepto actualizado correctamente']);
    }
    
    public function PA_EliminarConcepto($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $codigo);
        $conn->Parametro("@Descripcion", "");
        $conn->Parametro("@Tipo",        3);
    
        $conn->Procedimiento("dbo.PA_Conceptos");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Concepto eliminado correctamente']);
    }
    
    public function PA_InsertarConceptoS($concepto)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      0); 
        $conn->Parametro("@Descripcion", $concepto['CON_Descripcion']);
        $conn->Parametro("@Tipo",        1);
    
        $conn->Procedimiento("dbo.PA_ConceptosS");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Concepto de egreso creado correctamente']);
    }
    
    public function PA_ActualizarConceptoS($concepto)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $concepto['CON_Codigo']);
        $conn->Parametro("@Descripcion", $concepto['CON_Descripcion']);
        $conn->Parametro("@Tipo",        2);
    
        $conn->Procedimiento("dbo.PA_ConceptosS");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Concepto de egreso actualizado correctamente']);
    }
    
    public function PA_EliminarConceptoS($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@Codigo",      $codigo);
        $conn->Parametro("@Descripcion", "");
        $conn->Parametro("@Tipo",        3);
    
        $conn->Procedimiento("dbo.PA_ConceptosS");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Concepto de egreso eliminado correctamente']);
    }
    
    public function PA_ListarEmpresa()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $query = "SELECT TOP 1 * FROM Empresa";
        $data  = $conn->Consulta($query);
    
        $conn->Desconectar();
    
        return json_encode($data ?: []);
    }

    public function PA_ActualizarEmpresa($empresa)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@EM_Codigo",                 $empresa['EM_Codigo']);
        $conn->Parametro("@EM_RazonSocial",            $empresa['EM_RazonSocial']);
        $conn->Parametro("@EM_NombreComercial",        $empresa['EM_NombreComercial']);
        $conn->Parametro("@EM_Ruc",                    $empresa['EM_Ruc']);
        $conn->Parametro("@EM_DireccionFiscal",        $empresa['EM_DireccionFiscal']);
        $conn->Parametro("@EM_UbigeoFiscal",           $empresa['EM_UbigeoFiscal']);
        $conn->Parametro("@EM_CodigoDireccionFiscal",  $empresa['EM_CodigoDireccionFiscal']);
        $conn->Parametro("@EM_CelularPrincipal",       $empresa['EM_CelularPrincipal']);
        $conn->Parametro("@EM_Web",                    $empresa['EM_Web']);
    
        $conn->Parametro("@EM_DireccionSucursal",      $empresa['EM_DireccionSucursal']);
        $conn->Parametro("@EM_UbigeoSucursal",         $empresa['EM_UbigeoSucursal']);
        $conn->Parametro("@EM_CodigoDireccionSucursal",$empresa['EM_CodigoDireccionSucursal']);
        $conn->Parametro("@EM_CelularSucursal",        $empresa['EM_CelularSucursal']);
    
        $conn->Parametro("@EM_DireccionSucursal2",     $empresa['EM_DireccionSucursal2']);
        $conn->Parametro("@EM_UbigeoSucursal2",        $empresa['EM_UbigeoSucursal2']);
        $conn->Parametro("@EM_CodigoDireccionSucursal2",$empresa['EM_CodigoDireccionSucursal2']);
        $conn->Parametro("@EM_CelularSucursal2",       $empresa['EM_CelularSucursal2']);
    
        $conn->Parametro("@EM_CarpetaFacturacion",     $empresa['EM_CarpetaFacturacion']);
        $conn->Parametro("@EM_URLCertificado",         $empresa['EM_URLCertificado']);
        $conn->Parametro("@EM_ClaveCertificado",       $empresa['EM_ClaveCertificado']);
    
        $conn->Parametro("@EM_CarpetaEnviados",        $empresa['EM_CarpetaEnviados']);
        $conn->Parametro("@EM_CarpetaRecibidos",       $empresa['EM_CarpetaRecibidos']);
        $conn->Parametro("@EM_CarpetaDescomprimidos",  $empresa['EM_CarpetaDescomprimidos']);
        $conn->Parametro("@EM_CarpetaInput",           $empresa['EM_CarpetaInput']);
        $conn->Parametro("@Em_CarpetaTemp",            $empresa['EM_CarpetaTemp']);
    
        $conn->Parametro("@Estado",                    $empresa['EM_Estado']);
    
        $conn->Parametro("@Tipo", 2);
    
        $conn->Procedimiento("dbo.PA_Empresa");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Empresa guardada correctamente']);
    }
    
    public function ObtenerSiguienteCodigoRol()
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $query = "SELECT ISNULL(MAX(rol_id), 0) + 1 AS SiguienteCodigo FROM dbo.rol";
        $data = $conn->Consulta($query);
    
        $conn->Desconectar();
    
        $siguiente = 1;
        if (is_array($data) && isset($data[0]['SiguienteCodigo']) && $data[0]['SiguienteCodigo']) {
            $siguiente = $data[0]['SiguienteCodigo'];
        }
        return $siguiente;
    }
    
    public function PA_InsertarRol($rol, $nuevoCodigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@rol_id",          $nuevoCodigo);
        $conn->Parametro("@rol_nombre",      $rol['rol_nombre']);
        $conn->Parametro("@rol_descripcion", $rol['rol_descripcion']);
        $conn->Parametro("@ROL_Estado",      isset($rol['ROL_Estado']) ? $rol['ROL_Estado'] : 'Habilitado');
        $conn->Parametro("@tipo",            1);
    
        $conn->Procedimiento("dbo.PA_Rol");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo, 'message' => 'Rol registrado correctamente.']);
    }
    
    public function PA_ActualizarRol($rol)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@rol_id",          $rol['rol_id']);
        $conn->Parametro("@rol_nombre",      $rol['rol_nombre']);
        $conn->Parametro("@rol_descripcion", $rol['rol_descripcion']);
        $conn->Parametro("@ROL_Estado",      $rol['ROL_Estado']); 
        $conn->Parametro("@tipo",            2);
    
        $conn->Procedimiento("dbo.PA_Rol");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Rol actualizado correctamente']);
    }
    
    public function PA_EliminarRol($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
    
        $conn->Parametro("@rol_id",          $codigo);
        $conn->Parametro("@rol_nombre",      '');   
        $conn->Parametro("@rol_descripcion", '');   
        $conn->Parametro("@ROL_Estado",      'Eliminado');    
        $conn->Parametro("@tipo",            3);              
    
        $conn->Procedimiento("dbo.PA_Rol");
        $conn->Desconectar();
    
        return json_encode(['success' => true, 'message' => 'Rol eliminado correctamente']);
    }
    
    public function PA_ListarRoles()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Descripcion", "");
        $data = $conn->Procedimiento("dbo.PA_ListarRol");
    
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_ObtenerLogoSistemaBase64()
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $data = $conn->Procedimiento("dbo.PA_ObtenerLogoSistemaWeb");
        
        $conn->Desconectar();
        
        if ($data && count($data) > 0) {
            $imagen = "";
            foreach ($data as $parte) {
                $imagen = $imagen . $parte[0]; 
            }
            
            $imagen_bin = hex2bin($imagen);
            $logoBase64 = base64_encode($imagen_bin);
            
            return json_encode(array(
                'success' => true,
                'logo' => $logoBase64
            ));
        }
        
        return json_encode(array(
            'success' => false,
            'message' => 'No hay logo en la base de datos'
        ));
    }
    
    public function PA_ActualizaLogoSistema($Logo)
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $logoHex = '0x' . bin2hex($Logo);
        
        $query = "UPDATE dbo.ConfiguracionPesada SET CI_ImagenSistema = $logoHex WHERE CI_Codigo = 1; EXEC dbo.PA_ProcesarLogoSistema";
        $conn->Consulta($query);
        
        $conn->Desconectar();
        
        return json_encode(array(
            'success' => true, 
            'message' => 'Logo actualizado correctamente'
        ));
    }
    
    public function PA_ActualizarGenerarXML($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $conn->Parametro("@CI_GenerarXML", $valor);
        $conn->Procedimiento("dbo.PA_GenerarXML"); // SP existente
        
        $conn->Desconectar();
        
        return json_encode(array(
            'success' => true,
            'message' => 'Configuración actualizada correctamente'
        ));
    }
    
    public function PA_ObtenerGenerarXML()
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $query = "SELECT CI_GenerarXML FROM ConfiguracionInicial";
        $data = $conn->Consulta($query);
        
        $conn->Desconectar();
        
        $valor = 'SI';
        if ($data && count($data) > 0 && isset($data[0]['CI_GenerarXML'])) {
            $valor = $data[0]['CI_GenerarXML'];
        }
        
        return json_encode(array(
            'success' => true,
            'valor' => $valor
        ));
    }

    public function PA_ActualizarFacturasNoEnviadas($habilitado, $dias)
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $conn->Parametro("@CI_FacturasNoEnviadas", $habilitado);
        $conn->Parametro("@CI_DiasFacturasNoEnviadas", $dias);
        $conn->Procedimiento("dbo.PA_ActualizarFacturasNoEnviadas");
        
        $conn->Desconectar();
        
        return json_encode(array(
            'success' => true,
            'message' => 'Configuración actualizada correctamente'
        ));
    }
    
    public function PA_ObtenerFacturasNoEnviadas()
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $query = "SELECT CI_FacturasNoEnviadas, CI_DiasFacturasNoEnviadas FROM ConfiguracionInicial";
        $data = $conn->Consulta($query);
        
        $conn->Desconectar();
        
        $habilitado = 'NO';
        $dias = 30;
        
        if ($data && count($data) > 0) {
            if (isset($data[0]['CI_FacturasNoEnviadas'])) {
                $habilitado = $data[0]['CI_FacturasNoEnviadas'];
            }
            if (isset($data[0]['CI_DiasFacturasNoEnviadas'])) {
                $dias = $data[0]['CI_DiasFacturasNoEnviadas'];
            }
        }
        
        return json_encode(array(
            'success' => true,
            'habilitado' => $habilitado,
            'dias' => $dias
        ));
    }

    public function PA_ActualizarStock0($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $conn->Parametro("@f", $valor); 
        $conn->Procedimiento("dbo.PA_ActualizarStockCero"); 
        
        $conn->Desconectar();
        
        return json_encode(array(
            'success' => true,
            'message' => 'Configuración actualizada correctamente'
        ));
    }
    
    public function PA_ObtenerStock0()
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $query = "SELECT CI_VerStockCero FROM ConfiguracionInicial";
        $data = $conn->Consulta($query);
        
        $conn->Desconectar();
        
        $valor = 'NO';
        if ($data && count($data) > 0 && isset($data[0]['CI_VerStockCero'])) {
            $valor = $data[0]['CI_VerStockCero'];
        }
        
        return json_encode(array(
            'success' => true,
            'valor' => $valor
        ));
    }

    public function PA_ActualizarValidarStock($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $conn->Parametro("@valor", $valor); 
        $conn->Procedimiento("dbo.PA_ActualizarValidarStock"); 
        
        $conn->Desconectar();
        
        return json_encode(array(
            'success' => true,
            'message' => 'Configuración actualizada correctamente'
        ));
    }
    
    public function PA_ObtenerValidarStock()
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $query = "SELECT CI_ValidarStock FROM ConfiguracionInicial";
        $data = $conn->Consulta($query);
        
        $conn->Desconectar();
        
        $valor = 'SI';
        if ($data && count($data) > 0 && isset($data[0]['CI_ValidarStock'])) {
            $valor = $data[0]['CI_ValidarStock'];
        }
        
        return json_encode(array(
            'success' => true,
            'valor' => $valor
        ));
    }


    public function PA_ActualizarCuentasPorCobrar($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $conn->Parametro("@CI_CuentasPorCobrar", $valor);
        $conn->Procedimiento("dbo.PA_ActualizarCuentasPorCobrar");
        
        $conn->Desconectar();
        
        return json_encode(array(
            'success' => true,
            'message' => 'Configuración actualizada correctamente'
        ));
    }
    
    public function PA_ObtenerCuentasPorCobrar()
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $query = "SELECT CI_CuentasPorCobrar FROM ConfiguracionInicial";
        $data = $conn->Consulta($query);
        
        $conn->Desconectar();
        
        $valor = 'SI';
        if ($data && count($data) > 0 && isset($data[0]['CI_CuentasPorCobrar'])) {
            $valor = $data[0]['CI_CuentasPorCobrar'];
        }
        
        return json_encode(array(
            'success' => true,
            'valor' => $valor
        ));
    }
    
    public function PA_ActualizarInicioTipoDocumento($valor)
{
        $conn = new Conexion();
        $conn->Conectar();
        
        $conn->Parametro("@CI_TIpoDocumentoInicio", $valor);
        $conn->Procedimiento("dbo.PA_ActualizarInicioTipoDocumento");
        
        $conn->Desconectar();
        
        return json_encode(array(
            'success' => true,
            'message' => 'Configuración actualizada correctamente'
        ));
    }
    
    public function PA_ObtenerInicioTipoDocumento()
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        
        $query = "SELECT CI_TIpoDocumentoInicio FROM ConfiguracionInicial";
        $data = $conn->Consulta($query);
        
        $conn->Desconectar();
        
        $valor = 'FACTURA';
        if ($data && count($data) > 0 && isset($data[0]['CI_TIpoDocumentoInicio'])) {
            $valor = $data[0]['CI_TIpoDocumentoInicio'];
        }
        
        return json_encode(array(
            'success' => true,
            'valor' => $valor
        ));
    }

    public function web_ListarPermisos()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.web_ListarPermisos");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function web_ObtenerPermisosUsuario($codigo)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@per_codigo", $codigo);
        $data = $conn->Procedimiento("dbo.web_ObtenerPermisosUsuario");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function web_VerificarPermiso($codigo, $slug)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@per_codigo", $codigo);
        $conn->Parametro("@slug", $slug);
        $data = $conn->Procedimiento("dbo.web_VerificarPermiso");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function web_AsignarPermisosUsuario($codigo, $ids)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@per_codigo", $codigo);
        $conn->Parametro("@permisos_ids", $ids);
        $data = $conn->Procedimiento("dbo.web_AsignarPermisosUsuario");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function web_AsignarPermisosRol($rol_id, $ids)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@rol_id", $rol_id);
        $conn->Parametro("@permisos_ids", $ids);
        $data = $conn->Procedimiento("dbo.web_AsignarPermisosRol");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function web_ListarPermisosRol($rol_id)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@rol_id", $rol_id);
        $data = $conn->Procedimiento("dbo.web_ListarPermisosRol");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_web_CrearPermiso($request)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@slug", $request['slug']);
        $conn->Parametro("@nombre", $request['nombre']);
        $conn->Parametro("@descripcion", $request['descripcion']);
        $conn->Parametro("@icono", $request['icono']);
        $conn->Parametro("@ruta", $request['ruta']);
        $conn->Parametro("@grupo", $request['grupo']);
        $conn->Parametro("@orden", $request['orden']);
        $data = $conn->Procedimiento("dbo.PA_web_CrearPermiso");
        $conn->Desconectar();
        return json_encode($data);
    }
    public function PA_web_ActualizarPermiso($request)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@id", $request['id']);
        $conn->Parametro("@slug", $request['slug']);
        $conn->Parametro("@nombre", $request['nombre']);
        $conn->Parametro("@descripcion", $request['descripcion']);
        $conn->Parametro("@icono", $request['icono']);
        $conn->Parametro("@ruta", $request['ruta']);
        $conn->Parametro("@grupo", $request['grupo']);
        $conn->Parametro("@orden", $request['orden']);
        $conn->Parametro("@activo", $request['activo']);
        $data = $conn->Procedimiento("dbo.PA_web_ActualizarPermiso");
        $conn->Desconectar();
        return json_encode($data);
    }
    public function PA_web_EliminarPermiso($id)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@id", $id);
        $data = $conn->Procedimiento("dbo.PA_web_EliminarPermiso");
        $conn->Desconectar();
        return json_encode($data);
    }
    public function PA_web_ObtenerPermisoPorId($id)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@id", $id);
        $data = $conn->Procedimiento("dbo.PA_web_ObtenerPermisoPorId");
        $conn->Desconectar();
        return json_encode($data);
    }
    
    public function PA_ObtenerFormatoImpresion()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarConfigruacionInicial");
        $conn->Desconectar();
        
        return json_encode($data ?: []);
    }
    
    public function PA_ActualizarFormatoImpresion($formatos)
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $conn->Parametro("@BoletaImpresion", $formatos['formato_boleta']);
        $conn->Parametro("@FacturaImpresion", $formatos['formato_factura']);
        $conn->Parametro("@ProformaImpresion", $formatos['formato_proforma']);
        $conn->Parametro("@CotizacionImpresion", $formatos['formato_cotizacion']);
        $conn->Parametro("@CI_FormatoCotizacionTicket", $formatos['formato_cotizacion_ticket']);
        $conn->Parametro("@CI_FormatoCotizacionA4", $formatos['formato_cotizacion_a4']);
        
        $conn->Procedimiento("dbo.PA_ActualizarFormatoImpresion");
        $conn->Desconectar();
        
        return json_encode(['success' => true, 'message' => 'Configuración actualizada correctamente']);
    }
    
    public function PA_ActualizarBEnter($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@f", $valor);
        $conn->Procedimiento("dbo.PA_ActualizarBEnter");
        $conn->Desconectar();
        
        return json_encode(['success' => true, 'message' => 'Configuración de Enter actualizada correctamente']);
    }
    public function PA_ActualizarBDescripcion($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@f", $valor);
        $conn->Procedimiento("dbo.PA_ActualizarBDescripcion");
        $conn->Desconectar();
        
        return json_encode(['success' => true, 'message' => 'Configuración de Descripción actualizada correctamente']);
    }
    public function PA_ActualizarFormularioEliminar($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@f", $valor);
        $conn->Procedimiento("dbo.PA_ActualizarFormularioEliminar");
        $conn->Desconectar();
        
        return json_encode(['success' => true, 'message' => 'Configuración actualizada correctamente']);
    }
    
    public function PA_ObtenerVerCodigoPermiso()
    {
        $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ObtenerVerCodigoPermiso");
        $conn->Desconectar();
        
        if (!empty($data) && isset($data[0]['CON_VerCodigoPermiso'])) {
            return json_encode([
                'success' => true,
                'valor' => $data[0]['CON_VerCodigoPermiso']
            ]);
        }
        
        return json_encode([
            'success' => true,
            'valor' => 'NO'
        ]);
    }
    
    public function PA_ActualizaVerCodigoPermiso($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@valor", $valor);
        $conn->Procedimiento("dbo.PA_ActualizaVerCodigoPermiso");
        $conn->Desconectar();
        
        return json_encode([
            'success' => true, 
            'message' => 'Configuración actualizada correctamente'
        ]);
    }
    public function PA_ActualizarFormaExportarFormatoPDF($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@GuardarExportarPDF", $valor);
        $conn->Procedimiento("inkamed1_bdferreteriavargas.PA_ActualizarFormaExportarFormatoPDF");
        $conn->Desconectar();
        
        return json_encode([
            'success' => true, 
            'message' => 'Configuración actualizada correctamente'
        ]);
    }
    public function PA_ActualizarExportarFormatoPDF($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@FormatoExportarPDF", $valor);
        $conn->Procedimiento("dbo.PA_ActualizarExportarFormatoPDF");
        $conn->Desconectar();
        
        return json_encode([
            'success' => true, 
            'message' => 'Formato de PDF actualizado correctamente'
        ]);
    }
    public function PA_ImprimirMarca($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CI_ImprimirMarca", $valor);
        $conn->Procedimiento("dbo.PA_ImprimirMarca");
        $conn->Desconectar();
        
        return json_encode([
            'success' => true, 
            'message' => 'Configuración de marca en ticket actualizada'
        ]);
    }
    
    public function PA_USARLOGOBD($valor)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@CI_LogoBaseDatos", $valor);
        $conn->Procedimiento("dbo.PA_USARLOGOBD");
        $conn->Desconectar();
        
        return json_encode([
            'success' => true, 
            'message' => 'Configuración de logo actualizada'
        ]);
    }
    public function PA_CambiarPlantillaRegistroContableVentas($tienda, $archivoBase64)
    {
        $conn = new Conexion();
        $conn->Conectar();
        
        $bytes = base64_decode($archivoBase64);
        
        $conn->Parametro("@Tienda", $tienda);
        $conn->Parametro("@PlantillaExcel", $bytes);
        $conn->Procedimiento("dbo.PA_CambiarPlantillaRegistroContableVentas");
        $conn->Desconectar();
        
        return json_encode([
            'success' => true, 
            'message' => 'Plantilla actualizada correctamente'
        ]);
    }
        public function PA_ObtenerPlantillaRegistroContableVentas($tienda)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Tienda", $tienda);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPlantillaRegistroContableVentas");
        $conn->Desconectar();
        
        if (is_array($data) && count($data) > 0 && isset($data[0]['CI_RegistroContableVentas'])) {
            $bytes = $data[0]['CI_RegistroContableVentas'];
            
            $base64 = base64_encode($bytes);
            
            return json_encode([
                'success' => true, 
                'archivo' => $base64
            ]);
        }
        
        return json_encode([
            'success' => false, 
            'message' => 'No hay plantilla almacenada'
        ]);
    }
    public function PA_ActualizarLector($request)
    {
        $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@val1", $request['val1']);
        $conn->Parametro("@val2", $request['val2']);
        $conn->Parametro("@val3", $request['val3']);
        $conn->Parametro("@val4", $request['val4']);
        $conn->Parametro("@val5", $request['val5']);
        $conn->Procedimiento("dbo.PA_ActualizarLector");
        $conn->Desconectar();
        
        return json_encode(['success' => true, 'message' => 'Configuración de lector actualizada']);
    }
}

$request = json_decode(file_get_contents('php://input'), true);

switch ($request['accion']) {
	case 'PA_Ventas_WEB':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_Ventas_WEB($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_Ventas_WEB2':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_Ventas_WEB2($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	    case 'PA_ObtenerVenta_PorCodigo_Detalle':
		try{
		    $VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerVenta_PorCodigo_Detalle($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ClienteWeb':
	    try{
		    $pedido = $request['cliente'];
        	$app = new Operaciones();
        	echo $app->PA_ClienteWeb($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_MODIFICAR_PEDIDO':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_MODIFICAR_PEDIDO($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_ListarProductos_PorDescripcion':
		try{
        	$buscar1 = $request['buscar1'];
        	
        	$app = new Operaciones();
        	echo $app->PA_ListarProductos_PorDescripcion($buscar1, $buscar2, $buscar3, $buscar4, $buscar5, $buscar6);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarConceptosI':
		try{
        
        	$app = new Operaciones();
        	echo $app->PA_ListarConceptosI();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ListarConceptosS':
		try{
        	
        	
        	$app = new Operaciones();
        	echo $app->PA_ListarConceptosS();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;        
    case 'PA_ObtenerPersonal_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerPersonal_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_OpcionQuitarDetalle_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_OpcionQuitarDetalle_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_DocumentosImprimir':
		try{
        	$codigo = $request['codigo'];
        	$tipo = $request['tipo'];
        	$formato = $request['formato'];
        	$app = new Operaciones();
        	echo $app->PA_DocumentosImprimir($codigo, $tipo, $formato);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'IngresarArticuloWeb':
		try{
        	$codigo = $request['Codigo'];
        	$Desc = $request['Desc'];
        	$Unidad = $request['Unidad'];
        	$Precio = $request['Precio'];
        	$app = new Operaciones();
        	echo $app->IngresarArticuloWeb($codigo, $Desc, $Unidad,$Precio);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarIngreso':
		try{
        	$Codigo = $request['Codigo'];
        	$Desc = $request['Desc'];
        	$Caja = $request['Caja'];
        	$Precio = $request['Precio'];
        	$Fecha = $request['Fecha'];
        	$Perso = $request['Personal'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarIngreso($Codigo, $Desc,$Precio,$Fecha,$Caja,$Perso);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarEgreso':
		try{
        	$Codigo = $request['Codigo'];
        	$Desc = $request['Desc'];
        	$Caja = $request['Caja'];
        	$Precio = $request['Precio'];
        	$Fecha = $request['Fecha'];
        	$Perso = $request['Personal'];
        	$Desti = $request['Dest'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarEgreso($Codigo, $Desc,$Precio,$Fecha,$Caja,$Perso,$Desti);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'IngresarConceptoIWeb':
		try{
        	$Desc = $request['Desc'];
        	$app = new Operaciones();
        	echo $app->IngresarConceptoIWeb($Desc);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;  
	case 'IngresarConceptoSWeb':
		try{
        	$Desc = $request['Desc'];
        	$app = new Operaciones();
        	echo $app->IngresarConceptoSWeb($Desc);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ObtenerDetallesVenta_PorCodigo':
		try{
        	$VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetallesVenta_PorCodigo($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerDetalleNCWeb_PorCodigo':
		try{
        	$VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetalleNCWeb_PorCodigo($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ObtenerVenta_PorCodigo_Cabecera':
		try{
		    $VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerVenta_PorCodigo_Cabecera($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerNArticulo':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerNArticulo();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerNingreso':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerNingreso();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerNsalida':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerNsalida();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_Obtener_notas_electronicasWeb':
		try{
		    $VEN_Codigo = $request['VEN_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_Obtener_notas_electronicasWeb($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulosWeb':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulosWeb($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarVentasWeb_PorTipo':
		try{
        	$inicio = $request['Inicio'];
        	$final = $request['Final'];
        	$codvendedor = $request['CodVendedor'];
        	$estado = $request['Estado'];
        	$tipo = $request['Tipo'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarVentasWeb_PorTipo($inicio, $final, $codvendedor, $estado, $tipo,$buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarVentas2':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
        	$Cliente = $request['Cliente'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarVentas2($Inicio, $Final, $Cliente, $buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarCompras':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCompras($Inicio, $Final, $buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_Facturacion':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_Facturacion($Inicio, $Final, $buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_NotaCredito':
		try{
        	$Inicio = $request['Inicio'];
        	$Final = $request['Final'];
            $buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_NotaCredito($Inicio, $Final, $buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ListarPersonalWeb_PorDescripcion':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonalWeb_PorDescripcion($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarClientesWeb':
		try{
        	$buscar = $request['buscar'];
        	$app = new Operaciones();
        	echo $app->PA_ListarClientesWeb($buscar);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_Pedido_JE_ConTransaccion_Eliminar':
		try{
        	$PED_Codigo = $request['PED_Codigo'];
        	$MES_Codigo = $request['MES_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_Pedido_JE_ConTransaccion_Eliminar($PED_Codigo, $MES_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_VerCambios':
		try{
        	$app = new Operaciones();
        	echo $app->PA_VerCambios($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarComidas_ConReceta':
		try{
        	$Descripcion = $request['Descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarComidas_ConReceta($Descripcion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ValiarPlatosProgramados':
		try{
        	$_platosProgramados = $request['_platosProgramados'];
        	$_cantidadProgramados = $request['_cantidadProgramados'];
        	$app = new Operaciones();
        	echo $app->PA_ValiarPlatosProgramados($_platosProgramados, $_cantidadProgramados);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ReporteComidas_PorFechas':
		try{
        	$Inicio = $request['Inicio'];
        	$Fin = $request['Fin'];
        	$Cat = $request['Cat'];
        	$Panel = $request['Panel'];
        	$Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ReporteComidas_PorFechas($Inicio, $Fin, $Cat, $Panel, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ReporteInsumos_AlaFecha':
		try{
        	$Inicio1 = $request['Inicio1'];
        	$Inicio2 = $request['Inicio2'];
        	$Inicio3 = $request['Inicio3'];
        	$Inicio4 = $request['Inicio4'];
        	$Inicio5 = $request['Inicio5'];
        	$Inicio6 = $request['Inicio6'];
        	$Inicio7 = $request['Inicio7'];
        	$Fin = $request['Fin'];
        	$Cat = $request['Cat'];
        	$Panel = $request['Panel'];
        	$Nombre = $request['Nombre'];
        	$Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ReporteInsumos_AlaFecha($Inicio1, $Inicio2, $Inicio3, $Inicio4, $Inicio5, $Inicio6, $Inicio7, $Fin, $Cat, $Panel, $Nombre, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulos_Programacion_PorDescripcion':
		try{
        	$id = $request['descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulos_Programacion_PorDescripcion($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarPedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarDetallesDePedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarDetallesDePedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_GeneraCodigoPedido':
		try{
        	$app = new Operaciones();
        	echo $app->PA_GeneraCodigoPedido();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_EliminarTablaTemporal_PorCodigoPedido':
		try{
		    $id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_EliminarTablaTemporal_PorCodigoPedido($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarTablaTemporal':
		try{
		    $detalles = $request['detalles'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarTablaTemporal($detalles);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarMesasxUbicacion':
		try{
		    $ubicacion = $request['ubicacion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarMesasxUbicacion($ubicacion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPersonalVer':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonalVer();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajaVer':
		try{
		    $sucursal = $request['sucursal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCajaVer($sucursal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'ActualizaImpresionPedido':
		try{
		    $id = $request['codigo'];
		    $valor = $request['valor'];
        	$app = new Operaciones();
        	echo $app->ActualizaImpresionPedido($id, $valor);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_SOLO_CLIENTE':
		try{
		    $PED_Codigo = $request['PED_Codigo'];
		    $cliente = $request['cliente'];
		    $observaciones = $request['observaciones'];
        	$app = new Operaciones();
        	echo $app->PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarZonasMesa':
		try{
		    $descripcion = $request['Descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarZonasMesa($descripcion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	
	case 'PA_ListarCategorias_PorAbreviatura':
		try{
		    $abreviatura = $request['abreviatura'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCategorias_PorAbreviatura($abreviatura);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarCategorias':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarCategorias();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulosxCategoria_Programacion':
		try{
		    $categoria = $request['Categoria'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulosxCategoria_Programacion($categoria);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPermisosWeb_PorUsuario':
		try{
		    $id = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPermisosWeb_PorUsuario($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerEstadoSeEstaCobrando_PorCodigo':
		try{
		    $PER_Codigo = $request['PER_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerEstadoSeEstaCobrando_PorCodigo($PER_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_EstadoCaja_xCodigo_WEB':
	    try{
		    $CD_Codigo = $request['CD_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_EstadoCaja_xCodigo_WEB($CD_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarIngresosDineroEntreFechasXCaja':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarIngresosDineroEntreFechasXCaja($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarIngresosDineroWEB':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarIngresosDineroWEB($FechaInicio, $FechaFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
		case 'PA_ListarEgresosDineroWEB':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarEgresosDineroWEB($FechaInicio, $FechaFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;     
    case 'PA_ListarSalidasDineroEntreFechasxCaja':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
		    $Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarSalidasDineroEntreFechasxCaja($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarVentas_WEB':
	    try{
		    $FechaInicio = $request['FechaInicio'];
		    $FechaFinal = $request['FechaFinal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarVentas_WEB($FechaInicio, $FechaFinal, $Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulos_PorTipo':
	    try{
		    $Tipo = $request['Tipo'];
		    $Descripcion = $request['Descripcion'];
		    $Categoria = $request['Categoria'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulos_PorTipo($Tipo, $Descripcion, $Categoria);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarInsumos_WEB':
	    try{
		    $Descripcion = $request['descrip'];
		    $Categoria = $request['cat'];
		    $Tipo = $request['tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarInsumos_WEB($Descripcion, $Categoria, $Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarCategorias_PorTipoWEB':
	    try{
		    $Tipo = $request['Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCategorias_PorTipoWEB($Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarBebidasStockMinimo':
	    try{
        	$app = new Operaciones();
        	echo $app->PA_ListarBebidasStockMinimo();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarInsumosStockMinimo':
	    try{
        	$app = new Operaciones();
        	echo $app->PA_ListarInsumosStockMinimo();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajasxFecha':
	    try{
	        $fechaInicio = $request['fechaInicio'];
	        $fechaFinal = $request['fechaFinal'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCajasxFecha($fechaInicio, $fechaFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_BuscarFormulario_PorCliente_WEB':
	    try{
	        $FDM_NombreCliente = $request['FDM_NombreCliente'];
	        $FDM_Tipo = $request['FDM_Tipo'];
        	$app = new Operaciones();
        	echo $app->PA_BuscarFormulario_PorCliente_WEB($FDM_NombreCliente, $FDM_Tipo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerPedido_PorCodigo_WEB':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerPedido_PorCodigo_WEB($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerIngreso_PorCodigo':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerIngreso_PorCodigo($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;    
	case 'PA_ObtenerDetalleVentaWeb_PorCodigo':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetalleVentaWeb_PorCodigo($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerDetallePedido_PorCodigo_WEB':
	    try{
	        $PED_Codigo = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDetallePedido_PorCodigo_WEB($PED_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerFormularioDeliveryMostrador_PorCodigo':
	    try{
	        $FDM_Codigo = $request['FDM_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerFormularioDeliveryMostrador_PorCodigo($FDM_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarFormularioDeliveryMostrador':
	    try{
	        $obj = $request['obj'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarFormularioDeliveryMostrador($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerLogoSistema':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerLogoSistema();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajaxCodigo':
		try{
        	$app = new Operaciones();
        	$Codigo = $request['Codigo'];
        	echo $app->PA_ListarCajaxCodigo($Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_CajaDinero_WEB':
		try{
        	$app = new Operaciones();
        	$SaldoInicial = $request['SaldoInicial'];
        	$CodigoPersonal = $request['CodigoPersonal'];
        	$Almacen = $request['Almacen'];
        	$Tipo = $request['Tipo'];
        	
        	$xCD = $request['xCD'];
        	$Ingresos = $request['Ingresos'];
        	$Egresos = $request['Egresos'];
        	$SaldoActual = $request['SaldoActual'];
        	$Retiro = $request['Retiro'];
        	$SaldoFinal = $request['SaldoFinal'];
        	echo $app->PA_CajaDinero_WEB($SaldoInicial, $CodigoPersonal, $Almacen, $Tipo, $xCD, $Ingresos, $Egresos, $SaldoActual, $Retiro, $SaldoFinal);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB1':
		try{
        	$app = new Operaciones();
        	$CodigoCaja = $request['Codigo'];
        	echo $app->PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB1($CodigoCaja);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB2':
		try{
        	$app = new Operaciones();
        	$CodigoCaja = $request['Codigo'];
        	echo $app->PA_ObtenerValoresCaja_PorCodigo_NuevoDETALLADO2_WEB2($CodigoCaja);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarFormaPago':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarFormaPago();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_IngresoDinero_WEB':
		try{
        	$app = new Operaciones();
        	$Obj = $request['Obj'];
        	echo $app->PA_IngresoDinero_WEB($Obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ObtenerIngresoDinero_WEB':
		try{
        	$app = new Operaciones();
        	$id = $request['id'];
        	echo $app->PA_ObtenerIngresoDinero_WEB($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ObtenerSalidaDinero_WEB':
		try{
        	$app = new Operaciones();
        	$id = $request['id'];
        	echo $app->PA_ObtenerSalidaDinero_WEB($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_SalidaDinero_WEB':
		try{
        	$app = new Operaciones();
        	$Obj = $request['Obj'];
        	echo $app->PA_SalidaDinero_WEB($Obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ObtenerVenta_PorCodigo':
		try{
        	$app = new Operaciones();
        	$VEN_Codigo = $request['VEN_Codigo'];
        	echo $app->PA_ObtenerVenta_PorCodigo($VEN_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ObtenerLogoEmpresa':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ObtenerLogoEmpresa();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
    case 'PA_ListarProveedores':
        try{
            $app = new Operaciones();
            echo $app->PA_ListarProveedores();
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarProveedorxRUC':
        try{
            $app = new Operaciones();
            $ruc = $request['PRO_Ruc'];
            echo $app->PA_ListarProveedorxRUC($ruc);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarProveedorxRazonSocial':
        try{
            $app = new Operaciones();
            $razonSocial = $request['PRO_RazonSocial'];
            echo $app->PA_ListarProveedorxRazonSocial($razonSocial);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
        
    case 'PA_InsertarProveedor':
        try {
            $app = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoProveedor();
            $proveedor = $request['proveedor'];
            $app->PA_InsertarProveedor($proveedor, $nuevoCodigo);
            echo json_encode(['success' => true, 'NuevoCodigo' => $nuevoCodigo]);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_InsertarContactoProveedor':
        try {
            $contacto = $request['contacto'];
            $app = new Operaciones();
            $app->PA_InsertarContactoProveedor($contacto);
            echo json_encode(['success' => true]);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_ActualizarContactoProveedor':
        try {
            $contacto = $request['contacto'];
            $app = new Operaciones();
            $app->PA_ActualizarContactoProveedor($contacto);
            echo json_encode(['success' => true]);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;

    
    case 'PA_EliminarContactoProveedor':
        try {
            $contacto = $request['contacto'];
            $app = new Operaciones();
            $app->PA_EliminarContactoProveedor($contacto);
            echo json_encode(['success' => true]);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_ListarContactosProveedor':
        try {
            $codigo = $request['PROV_Codigo'];
            $app = new Operaciones();
            echo $app->PA_ListarContactosProveedor($codigo);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_ListarTelefonosProveedor':
        try {
            $codigo = $request['PROV_Codigo'];
            $app = new Operaciones();
            echo $app->PA_ListarTelefonosProveedor($codigo);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;

    case 'PA_ListarCuentasProveedor':
        try {
            $codigo = $request['PROV_Codigo'];
            $app = new Operaciones();
            echo $app->PA_ListarCuentasProveedor($codigo);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
            
    case 'PA_ActualizarProveedor':
        try {
            $app = new Operaciones();
            $proveedor = $request['proveedor'];
            echo $app->PA_ActualizarProveedor($proveedor);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_ObtenerProveedor':
        try {
            $app = new Operaciones();
            $codigo = $request['PRO_Codigo'];
            echo $app->PA_ObtenerProveedor($codigo);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_EliminarProveedor':
        try {
            $app = new Operaciones();
            $codigo = $request['PRO_Codigo'];
            echo $app->PA_EliminarProveedor($codigo);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;

    case 'PA_ListarTipoOperador':
        try {
            $Descripcion = isset($request['Descripcion']) ? $request['Descripcion'] : '';
            $app = new Operaciones();
            echo $app->PA_ListarTipoOperador($Descripcion);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarTipoTelefono':
        try {
            $Descripcion = isset($request['Descripcion']) ? $request['Descripcion'] : '';
            $app = new Operaciones();
            echo $app->PA_ListarTipoTelefono($Descripcion);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;

    
    case 'PA_InsertarTelefonoProveedor':
        try {
            $telefono = $request['telefono'];
            $app = new Operaciones();
            $app->PA_InsertarTelefonoProveedor($telefono);
            echo json_encode(['success' => true]);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_DetalleTelefono_Eliminar':
        try {
            $detalle = $request['detalle'];
            $app = new Operaciones();
            $app->PA_DetalleTelefono_Eliminar($detalle);
            echo json_encode(['success' => true]);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_ListarEntidadesFinancieras': 
        try {
            $Descripcion = isset($request['Descripcion']) ? $request['Descripcion'] : '';
            $app = new Operaciones();
            echo $app->PA_ListarEntidadesFinancieras($Descripcion);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarTiposCuenta':
        try {
            $Descripcion = isset($request['Descripcion']) ? $request['Descripcion'] : '';
            $EF_Codigo = isset($request['EF_Codigo']) ? $request['EF_Codigo'] : '';
            $app = new Operaciones();
            echo $app->PA_ListarTiposCuenta($Descripcion, $EF_Codigo);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_InsertarCuentaProveedor':
        try {
            $cuenta = $request['cuenta'];
            $app = new Operaciones();
            $app->PA_InsertarCuentaProveedor($cuenta);
            echo json_encode(['success' => true]);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_DetalleCuentas_Eliminar':
        try {
            $detalle = $request['detalle'];
            $app = new Operaciones();
            $app->PA_DetalleCuentas_Eliminar($detalle);
            echo json_encode(['success' => true]);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
        
    case 'PA_ListarCargos':
		try{
        	$Estado = $request['Estado'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCargos($Estado);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ListarAreas':
		try{
        	$Estado = $request['Estado'];
        	$app = new Operaciones();
        	echo $app->PA_ListarAreas($Estado);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;  
	    
	case 'PA_ListarCondicion':
		try{
        	$Estado = $request['Estado'];
        	$app = new Operaciones();
        	echo $app->PA_ListarCondicion($Estado);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;  
	    
	case 'PA_Personal':
		try{
			$obj = $request['obj'];
			$app = new Operaciones();
			echo $app->PA_Personal($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ListarPersonalXCodigo':
		try{
			$obj = $request['Codigo'];
			$app = new Operaciones();
			echo $app->PA_ListarPersonalXCodigo($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ListarCodigosPersonal':
		try{
			$app = new Operaciones();
			echo $app->PA_ListarCodigosPersonal($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ListarClientes':
        try{
            $app = new Operaciones();
            echo $app->PA_ListarClientes();
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarClientes_PorDescripcion':
        try{
            $app = new Operaciones();
            $razonSocial = $request['CLI_RazonSocial'];
            echo $app->PA_ListarClientes_PorDescripcion($razonSocial);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarClientes_PorDNIRUC':
        try{
            $app = new Operaciones();
            $codigo = $request['CLI_Codigo'];
            echo $app->PA_ListarClientes_PorDNIRUC($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarClientes_PorCondicion':
        try{
            $app = new Operaciones();
            $condicion = $request['CLI_Condicion'];
            echo $app->PA_ListarClientes_PorCondicion($condicion);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_InsertarCliente':
        try {
            $app = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoCliente();
            $cliente = $request['cliente'];
            echo $app->PA_InsertarCliente($cliente, $nuevoCodigo);
        } catch (Exception $ex) {
            echo json_encode(array('error' => $ex->getMessage()));
        }
        break;
    
    case 'PA_ActualizarCliente':
        try{
            $app = new Operaciones();
            $cliente = $request['cliente'];
            echo $app->PA_ActualizarCliente($cliente);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarCliente':
        try{
            $app = new Operaciones();
            $cliente = $request['cliente'];
            echo $app->PA_EliminarCliente($cliente);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ObtenerCliente':
        try{
            $app = new Operaciones();
            $cli_id = $request['CLI_DNIRUC'];
            echo $app->PA_ObtenerCliente($cli_id);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarUsuarios':
		try{
        	$Estado = $request['Estado'];
        	$app = new Operaciones();
        	echo $app->PA_ListarUsuarios($Estado);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ListarUsuariosxNombres':
		try{
        	$Nombres = $request['nombres'];
        	$app = new Operaciones();
        	echo $app->PA_ListarUsuariosxNombres($Nombres);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_ListarUsuarioxCodigo':
		try{
        	$Codigo = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarUsuarioxCodigo($Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
    case 'PA_Usuario':
		try{
			$obj = $request['obj'];
			$app = new Operaciones();
			echo $app->PA_Usuario($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
    case 'PA_Usuario_ModificarNick':
		try{
			$obj = $request['obj'];
			$app = new Operaciones();
			echo $app->PA_Usuario_ModificarNick($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
    case 'PA_Usuario_ModificarOpciones':
		try{
			$obj = $request['obj'];
			$app = new Operaciones();
			echo $app->PA_Usuario_ModificarOpciones($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_Usuario_ModificarContraseña':
		try{
			$obj = $request['obj'];
			$app = new Operaciones();
			echo $app->PA_Usuario_ModificarContraseña($obj);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	    
	case 'PA_InsertarCargo':
        try{
            $app = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoCargo();
            $cargo = $request['cargo'];
            echo $app->PA_InsertarCargo($cargo, $nuevoCodigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;

    case 'PA_ActualizarCargo':
        try{
            $app = new Operaciones();
            $cargo = $request['cargo'];
            echo $app->PA_ActualizarCargo($cargo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;

    case 'PA_EliminarCargo':
        try{
            $app = new Operaciones();
            $codigo = $request['CAR_Codigo'];  
            echo $app->PA_EliminarCargo($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_InsertarArea':
        try {
            $app = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoArea();
            $area = $request['area'];
            echo $app->PA_InsertarArea($area, $nuevoCodigo);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarArea':
        try {
            $app = new Operaciones();
            $area = $request['area'];
            echo $app->PA_ActualizarArea($area);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarArea':
        try {
            $app = new Operaciones();
            $codigo = $request['AREA_Codigo'];
            echo $app->PA_EliminarArea($codigo);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
        
    case 'PA_InsertarCondicionLaboral':
        try{
            $app = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoCondicionLaboral();
            $condicion   = $request['condicion'];
            echo $app->PA_InsertarCondicionLaboral($condicion, $nuevoCodigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarCondicionLaboral':
        try{
            $app = new Operaciones();
            $condicion = $request['condicion']; 
            echo $app->PA_ActualizarCondicionLaboral($condicion);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarCondicionLaboral':
        try{
            $app    = new Operaciones();
            $codigo = $request['CON_Codigo'];
            echo $app->PA_EliminarCondicionLaboral($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
        
    case 'PA_InsertarTipoOrden':
        try{
            $app = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoTipoOrden();
            $tipoOrden   = $request['tipoOrden']; 
            echo $app->PA_InsertarTipoOrden($tipoOrden, $nuevoCodigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarTipoOrden':
        try{
            $app = new Operaciones();
            $tipoOrden = $request['tipoOrden'];
            echo $app->PA_ActualizarTipoOrden($tipoOrden);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarTipoOrden':
        try{
            $app    = new Operaciones();
            $codigo = $request['TOO_Codigo'];
            echo $app->PA_EliminarTipoOrden($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarTipoOrden':
        try{
            $Estado = $request['Estado']; 
            $app = new Operaciones();
            echo $app->PA_ListarTipoOrden($Estado);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
	
	case 'PA_InsertarCategoria':
        try{
            $app = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoCategoria();
            $categoria = $request['categoria'];
            echo $app->PA_InsertarCategoria($categoria, $nuevoCodigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarCategoria':
        try{
            $app = new Operaciones();
            $categoria = $request['categoria'];
            echo $app->PA_ActualizarCategoria($categoria);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarCategoria':
        try{
            $app = new Operaciones();
            $codigo = $request['CAT_Codigo'];
            echo $app->PA_EliminarCategoria($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
        
    case 'PA_InsertarPresentacion':
        try{
            $app = new Operaciones();
            $nuevoCodigo  = $app->ObtenerSiguienteCodigoPresentacion();
            $presentacion = $request['presentacion'];
            echo $app->PA_InsertarPresentacion($presentacion, $nuevoCodigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarPresentacion':
        try{
            $app = new Operaciones();
            $presentacion = $request['presentacion'];
            echo $app->PA_ActualizarPresentacion($presentacion);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarPresentacion':
        try{
            $app = new Operaciones();
            $codigo = $request['PRE_Codigo'];  
            echo $app->PA_EliminarPresentacion($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarPresentaciones':
        try{
            $app = new Operaciones();
            echo $app->PA_ListarPresentaciones();
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_InsertarUnidadMedida':
        try{
            $app           = new Operaciones();
            $nuevoCodigo   = $app->ObtenerSiguienteCodigoUnidadMedida();
            $unidad        = $request['unidad'];
            echo $app->PA_InsertarUnidadMedida($unidad, $nuevoCodigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarUnidadMedida':
        try{
            $app    = new Operaciones();
            $unidad = $request['unidad'];
            echo $app->PA_ActualizarUnidadMedida($unidad);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarUnidadMedida':
        try{
            $app    = new Operaciones();
            $codigo = $request['UNM_Codigo'];
            echo $app->PA_EliminarUnidadMedida($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarUnidadMedidas':
        try{
            $app = new Operaciones();
            echo $app->PA_ListarUnidadMedidas();
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
        
    case 'PA_InsertarEntidadFinanciera':
        try{
            $app     = new Operaciones();
            $entidad = $request['entidad'];
            echo $app->PA_InsertarEntidadFinanciera($entidad);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarEntidadFinanciera':
        try{
            $app     = new Operaciones();
            $entidad = $request['entidad'];
            echo $app->PA_ActualizarEntidadFinanciera($entidad);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarEntidadFinanciera':
        try{
            $app    = new Operaciones();
            $codigo = $request['EF_Codigo'];
            echo $app->PA_EliminarEntidadFinanciera($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarEntidades':
        try{
            $app    = new Operaciones();
            $Estado = $request['Estado'];
            echo $app->PA_ListarEntidades($Estado);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_InsertarFormaPago':
        try{
            $app         = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoFormaPago();
            $forma       = $request['forma'];
            echo $app->PA_InsertarFormaPago($forma, $nuevoCodigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarFormaPago':
        try{
            $app   = new Operaciones();
            $forma = $request['forma'];
            echo $app->PA_ActualizarFormaPago($forma);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarFormaPago':
        try{
            $app    = new Operaciones();
            $codigo = $request['Codigo'];
            echo $app->PA_EliminarFormaPago($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;

	case 'PA_SelfTest':
		echo json_encode(['ok'=>true,'ts'=>date('c')]);
		break;   
		
    case 'PA_InsertarTiposCuenta':
        try{
            $app  = new Operaciones();
            $tipo = $request['tipo']; 
            echo $app->PA_InsertarTiposCuenta($tipo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarTiposCuenta':
        try{
            $app  = new Operaciones();
            $tipo = $request['tipo'];
            echo $app->PA_ActualizarTiposCuenta($tipo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarTiposCuenta':
        try{
            $app    = new Operaciones();
            $codigo = $request['TC_Codigo'];
            echo $app->PA_EliminarTiposCuenta($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarCuentas':
        try{
            $app = new Operaciones();
            echo $app->PA_ListarCuentas();
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_InsertarTiposTelefono':
        try{
            $app  = new Operaciones();
            $tipo = $request['tipo']; 
            echo $app->PA_InsertarTiposTelefono($tipo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarTiposTelefono':
        try{
            $app  = new Operaciones();
            $tipo = $request['tipo'];
            echo $app->PA_ActualizarTiposTelefono($tipo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarTiposTelefono':
        try{
            $app    = new Operaciones();
            $codigo = $request['TT_Codigo'];
            echo $app->PA_EliminarTiposTelefono($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarTiposTelefono':
        try{
            $app = new Operaciones();
            echo $app->PA_ListarTipoTelefono();
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_InsertarTipoOperador':
        try{
            $app  = new Operaciones();
            $tipo = $request['tipo']; 
            echo $app->PA_InsertarTipoOperador($tipo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarTipoOperador':
        try{
            $app  = new Operaciones();
            $tipo = $request['tipo'];
            echo $app->PA_ActualizarTipoOperador($tipo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarTipoOperador':
        try{
            $app    = new Operaciones();
            $codigo = $request['TO_Codigo'];
            echo $app->PA_EliminarTipoOperador($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarTiposOperador':
        try{
            $app = new Operaciones();
            echo $app->PA_ListarTipoOperador();
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_InsertarConcepto':
        try{
            $app       = new Operaciones();
            $concepto  = $request['concepto']; 
            echo $app->PA_InsertarConcepto($concepto);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarConcepto':
        try{
            $app       = new Operaciones();
            $concepto  = $request['concepto']; 
            echo $app->PA_ActualizarConcepto($concepto);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarConcepto':
        try{
            $app    = new Operaciones();
            $codigo = $request['CON_Codigo'];
            echo $app->PA_EliminarConcepto($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;

    case 'PA_InsertarConceptoS':
        try{
            $app      = new Operaciones();
            $concepto = $request['concepto']; 
            echo $app->PA_InsertarConceptoS($concepto);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarConceptoS':
        try{
            $app      = new Operaciones();
            $concepto = $request['concepto']; 
            echo $app->PA_ActualizarConceptoS($concepto);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarConceptoS':
        try{
            $app    = new Operaciones();
            $codigo = $request['CON_Codigo'];
            echo $app->PA_EliminarConceptoS($codigo);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    case 'PA_ListarEmpresa':
        try {
            $app = new Operaciones();
            echo $app->PA_ListarEmpresa();
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarEmpresa':
        try {
            $app     = new Operaciones();
            $empresa = $request['empresa'];
            echo $app->PA_ActualizarEmpresa($empresa);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;

    case 'PA_InsertarRol':
        try {
            $app = new Operaciones();
            $nuevoCodigo = $app->ObtenerSiguienteCodigoRol();
            $rol = $request['rol'];
            echo $app->PA_InsertarRol($rol, $nuevoCodigo);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarRol':
        try {
            $app = new Operaciones();
            $rol = $request['rol'];
            echo $app->PA_ActualizarRol($rol);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_EliminarRol':
        try {
            $app = new Operaciones();
            $codigo = $request['rol_id'];
            echo $app->PA_EliminarRol($codigo);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ListarRoles':
        try {
            $app = new Operaciones();
            echo $app->PA_ListarRoles();
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
        
    case 'PA_ObtenerLogoSistemaBase64':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerLogoSistemaBase64();
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
        
    case 'PA_ActualizaLogoSistema':
        try {
            $app = new Operaciones();
            $logoBase64 = $request['logo'];
            $logoBinario = base64_decode($logoBase64);
            echo $app->PA_ActualizaLogoSistema($logoBinario);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
        
    case 'PA_ActualizarGenerarXML':
        try {
            $app = new Operaciones();
            $valor = isset($request['valor']) ? $request['valor'] : 'SI';
            echo $app->PA_ActualizarGenerarXML($valor);
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ObtenerGenerarXML':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerGenerarXML();
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    
    case 'PA_ActualizarFacturasNoEnviadas':
        try {
            $app = new Operaciones();
            $habilitado = isset($request['habilitado']) ? $request['habilitado'] : 'NO';
            $dias = isset($request['dias']) ? $request['dias'] : 30;
            echo $app->PA_ActualizarFacturasNoEnviadas($habilitado, $dias);
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ObtenerFacturasNoEnviadas':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerFacturasNoEnviadas();
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    
    case 'PA_ActualizarStock0':
        try {
            $app = new Operaciones();
            $valor = isset($request['valor']) ? $request['valor'] : 'NO';
            echo $app->PA_ActualizarStock0($valor);
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ObtenerStock0':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerStock0();
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ActualizarValidarStock':
        try {
            $app = new Operaciones();
            $valor = isset($request['valor']) ? $request['valor'] : 'SI';
            echo $app->PA_ActualizarValidarStock($valor);
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ObtenerValidarStock':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerValidarStock();
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ActualizarCuentasPorCobrar':
        try {
            $app = new Operaciones();
            $valor = isset($request['valor']) ? $request['valor'] : 'SI';
            echo $app->PA_ActualizarCuentasPorCobrar($valor);
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ObtenerCuentasPorCobrar':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerCuentasPorCobrar();
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ActualizarInicioTipoDocumento':
        try {
            $app = new Operaciones();
            $valor = isset($request['valor']) ? $request['valor'] : 'Factura';
            echo $app->PA_ActualizarInicioTipoDocumento($valor);
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ObtenerInicioTipoDocumento':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerInicioTipoDocumento();
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ListarTipoDocumento':
        try {
            $app = new Operaciones();
            echo $app->PA_ListarTipoDocumento();
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ActualizarInicioTipoDocumento':
        try {
            $app = new Operaciones();
            $valor = isset($request['valor']) ? $request['valor'] : 'FACTURA';
            echo $app->PA_ActualizarInicioTipoDocumento($valor);
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;
    case 'PA_ObtenerInicioTipoDocumento':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerInicioTipoDocumento();
        } catch (Exception $ex) {
            echo json_encode(array('success' => false, 'message' => $ex->getMessage()));
        }
        break;    
    case 'web_ListarPermisos':
        try {
            $app = new Operaciones();
            echo $app->web_ListarPermisos();
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
        
    case 'web_ObtenerPermisosUsuario':
        try {
            $app = new Operaciones();
            $codigo = $request['codigo'];
            echo $app->web_ObtenerPermisosUsuario($codigo);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
        
    case 'web_VerificarPermiso':
        try {
            $app = new Operaciones();
            $codigo = $request['codigo'];
            $slug = $request['slug'];
            echo $app->web_VerificarPermiso($codigo, $slug);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
        
    case 'web_AsignarPermisosUsuario':
        try {
            $app = new Operaciones();
            $codigo = $request['codigo'];
            $ids = $request['ids'];
            echo $app->web_AsignarPermisosUsuario($codigo, $ids);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
        
    case 'web_AsignarPermisosRol':
        try {
            $app = new Operaciones();
            $rol_id = $request['rol_id'];
            $ids = $request['ids'];
            echo $app->web_AsignarPermisosRol($rol_id, $ids);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;    
        
    case 'web_ListarPermisosRol':
        try {
            $app = new Operaciones();
            $rol_id = $request['rol_id'];
            echo $app->web_ListarPermisosRol($rol_id);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    case 'PA_web_CrearPermiso':
        try{
            $app = new Operaciones();
            echo $app->PA_web_CrearPermiso($request);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    case 'PA_web_ActualizarPermiso':
        try{
            $app = new Operaciones();
            echo $app->PA_web_ActualizarPermiso($request);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    case 'PA_web_EliminarPermiso':
        try{
            $id = $request['id'];
            $app = new Operaciones();
            echo $app->PA_web_EliminarPermiso($id);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    case 'PA_web_ObtenerPermisoPorId':
        try{
            $id = $request['id'];
            $app = new Operaciones();
            echo $app->PA_web_ObtenerPermisoPorId($id);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
    case 'PA_ObtenerFormatoImpresion':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerFormatoImpresion();
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    
    case 'PA_ActualizarFormatoImpresion':
        try {
            $app = new Operaciones();
            $formatos = $request;
            echo $app->PA_ActualizarFormatoImpresion($formatos);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    case 'PA_ActualizarBEnter':
        try {
            $app = new Operaciones();
            $valor = $request['valor'];
            echo $app->PA_ActualizarBEnter($valor);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    case 'PA_ActualizarBDescripcion':
        try {
            $app = new Operaciones();
            $valor = $request['valor'];
            echo $app->PA_ActualizarBDescripcion($valor);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
    case 'PA_ActualizarFormularioEliminar':
        try {
            $app = new Operaciones();
            $valor = $request['valor'];
            echo $app->PA_ActualizarFormularioEliminar($valor);
        } catch (Exception $ex) {
            echo json_encode($ex);
        }
        break;
     case 'PA_ObtenerVerCodigoPermiso':
        try {
            $app = new Operaciones();
            echo $app->PA_ObtenerVerCodigoPermiso();
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_ActualizaVerCodigoPermiso':
        try {
            $app = new Operaciones();
            $valor = $request['valor'];
            echo $app->PA_ActualizaVerCodigoPermiso($valor);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    case 'PA_ActualizarFormaExportarFormatoPDF':
        try {
            $app = new Operaciones();
            $valor = $request['valor'];
            echo $app->PA_ActualizarFormaExportarFormatoPDF($valor);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    case 'PA_ActualizarExportarFormatoPDF':
        try {
            $app = new Operaciones();
            $valor = $request['valor'];
            echo $app->PA_ActualizarExportarFormatoPDF($valor);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    case 'PA_ImprimirMarca':
        try {
            $app = new Operaciones();
            $valor = $request['valor'];
            echo $app->PA_ImprimirMarca($valor);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    
    case 'PA_USARLOGOBD':
        try {
            $app = new Operaciones();
            $valor = $request['valor'];
            echo $app->PA_USARLOGOBD($valor);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    case 'PA_CambiarPlantillaRegistroContableVentas':
        try {
            $app = new Operaciones();
            $tienda = 'DEFAULT';
            $archivo = $request['archivo'];
            echo $app->PA_CambiarPlantillaRegistroContableVentas($tienda, $archivo);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    case 'PA_ObtenerPlantillaRegistroContableVentas':
        try {
            $app = new Operaciones();
            $tienda = 'DEFAULT';
            echo $app->PA_ObtenerPlantillaRegistroContableVentas($tienda);
        } catch (Exception $ex) {
            echo json_encode(['error' => $ex->getMessage()]);
        }
        break;
    case 'PA_ActualizarLector':
        try{
            $app = new Operaciones();
            echo $app->PA_ActualizarLector($request);
        }catch (Exception $ex){
            echo json_encode($ex);
        }
        break;
}






