<?php
include '../ConsumoApiService/Conexion.php';
header("Content-Type: application/json; charset=UTF-8");

class Operaciones
{
    public function PA_ObtenerUsuario_PorNick($usuario)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@user", $usuario);
        $data = $conn->Procedimiento("dbo.PA_ObtenerUsuario_PorNick");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerEmpleado_PorCodigoWeb($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@per_codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerEmpleado_PorCodigoWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarDocumentos_Trabajador($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@per_codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarDocumentos_Trabajador");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerDocumento_PorCodigo($PD_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PD_Codigo", $PD_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerDocumento_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_CambiarClaveWeb($emp_id, $clave, $claven)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@emp_id", $emp_id);
        $conn->Parametro("@clave", $clave);
        $conn->Parametro("@claven", $claven);
        $data = $conn->Procedimiento("dbo.PA_CambiarClaveWeb");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarTablaTemporal($detalles)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = [];
        for($i=0; $i<count($detalles); $i++){
            $dd = $detalles[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $dd['Codigo']);
            $conn->Parametro("@CodigoProducto", $dd['CodigoProducto']);
            $conn->Parametro("@Cantidad", $dd['Cantidad']);
            $conn->Parametro("@Descripcion", $dd['Descripcion']);
            $conn->Parametro("@Accion", $dd['Accion']);
            $conn->Parametro("@Precio", $dd['Precio']);
            $data = $conn->Procedimiento("dbo.PA_InsertarTablaTemporal");   
        }
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
}

$request = json_decode(file_get_contents('php://input'), true);

switch ($request['accion']) {
	case 'PA_ObtenerUsuario_PorNick':
		try{
        	$usuario = $request['user'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerUsuario_PorNick($usuario);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerEmpleado_PorCodigoWeb':
		try{
		    $id = $request['id'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerEmpleado_PorCodigoWeb($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarDocumentos_Trabajador':
		try{
		    $id = $request['id'];
        	$app = new Operaciones();
        	echo $app->PA_ListarDocumentos_Trabajador($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ObtenerDocumento_PorCodigo':
		try{
		    $id = $request['id'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerDocumento_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_CambiarClaveWeb':
		try{
		    $emp_id = $request['emp_id'];
		    $clave = $request['clave'];
		    $claven = $request['claven'];
        	$app = new Operaciones();
        	echo $app->PA_CambiarClaveWeb($emp_id, $clave, $claven);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarTablaTemporal':
		try{
		    $detalles = $request['detalles'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarTablaTemporal($detalles);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
}



