<?php
include '../ConsumoApiTaypa2/Conexion.php';
header("Content-Type: application/json; charset=UTF-8");

class Operaciones
{
    public function PA_ObtenerPersonal_PorCodigo($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PER_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ObtenerPersonal_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarArticulos_Programacion_PorDescripcion($descripcion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@descripcion", $descripcion);
        $data = $conn->Procedimiento("dbo.PA_ListarArticulos_Programacion_PorDescripcion");
        $conn->Desconectar();
        return json_encode($data);
	}
    
	public function PA_ListarPedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarPedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarDetallesDePedidoxCodigoMesa($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_ListarDetallesDePedidoxCodigoMesa");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_GeneraCodigoPedido()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_GeneraCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_REGISTRAR_PEDIDO($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@CodCliente", $pedido['CodCliente']);
        $conn->Parametro("@CodMesa", $pedido['CodMesa']);
        $conn->Parametro("@NroPersonas", $pedido['NroPersonas']);
        $conn->Parametro("@Cliente", $pedido['Cliente']);
        $conn->Parametro("@Mesero", $pedido['Mesero']);
        $conn->Parametro("@Observaciones", $pedido['Observaciones']);
        $conn->Parametro("@TipoDocumento", $pedido['TipoDocumento']);
        $conn->Parametro("@Serie", $pedido['Serie']);
        $conn->Parametro("@Correlativo", $pedido['Correlativo']);
        $conn->Parametro("@SubTotal", $pedido['SubTotal']);
        $conn->Parametro("@IGV", $pedido['IGV']);
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@TipoPago", $pedido['TipoPago']);
        $conn->Parametro("@EstadoCuenta", $pedido['EstadoCuenta']);
        $conn->Parametro("@Estado", $pedido['Estado']);
        $conn->Parametro("@CodigoOperacionTarjeta", $pedido['CodigoOperacionTarjeta']);
        $conn->Parametro("@MontoOperacionTarjeta", $pedido['MontoOperacionTarjeta']);
        $conn->Parametro("@Impreso", $pedido['Impreso']);
        $conn->Parametro("@Dispositivo", $pedido['Dispositivo']);
        $conn->Parametro("@Forma", $pedido['Forma']);
        $conn->Parametro("@DetallePedido", $pedido['DetallePedido']);
        $conn->Parametro("@PER_Codigo", $pedido['PER_Codigo']);
        $data = $conn->Procedimiento("dbo.PA_REGISTRAR_PEDIDO");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_MODIFICAR_PEDIDO($pedido){
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@Codigo", $pedido['Codigo']);
        $conn->Parametro("@CodCliente", $pedido['CodCliente']);
        $conn->Parametro("@CodMesa", $pedido['CodMesa']);
        $conn->Parametro("@NroPersonas", $pedido['NroPersonas']);
        $conn->Parametro("@Cliente", $pedido['Cliente']);
        $conn->Parametro("@Mesero", $pedido['Mesero']);
        $conn->Parametro("@Observaciones", $pedido['Observaciones']);
        $conn->Parametro("@TipoDocumento", $pedido['TipoDocumento']);
        $conn->Parametro("@Serie", $pedido['Serie']);
        $conn->Parametro("@Correlativo", $pedido['Correlativo']);
        $conn->Parametro("@SubTotal", $pedido['SubTotal']);
        $conn->Parametro("@IGV", $pedido['IGV']);
        $conn->Parametro("@Total", $pedido['Total']);
        $conn->Parametro("@TipoPago", $pedido['TipoPago']);
        $conn->Parametro("@EstadoCuenta", $pedido['EstadoCuenta']);
        $conn->Parametro("@Estado", $pedido['Estado']);
        $conn->Parametro("@CodigoOperacionTarjeta", $pedido['CodigoOperacionTarjeta']);
        $conn->Parametro("@MontoOperacionTarjeta", $pedido['MontoOperacionTarjeta']);
        $conn->Parametro("@Impreso", $pedido['Impreso']);
        $conn->Parametro("@Dispositivo", $pedido['Dispositivo']);
        $conn->Parametro("@Forma", $pedido['Forma']);
        $conn->Parametro("@DetallePedido", $pedido['DetallePedido']);
        $data = $conn->Procedimiento("dbo.PA_MODIFICAR_PEDIDO");  
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_EliminarTablaTemporal_PorCodigoPedido($id)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $id);
        $data = $conn->Procedimiento("dbo.PA_EliminarTablaTemporal_PorCodigoPedido");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_InsertarTablaTemporal($detalles)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = [];
        for($i=0; $i<count($detalles); $i++){
            $dd = $detalles[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@Codigo", $dd['Codigo']);
            $conn->Parametro("@CodigoProducto", $dd['CodigoProducto']);
            $conn->Parametro("@Cantidad", $dd['Cantidad']);
            $conn->Parametro("@Descripcion", $dd['Descripcion']);
            $conn->Parametro("@Accion", $dd['Accion']);
            $conn->Parametro("@Precio", $dd['Precio']);
            $data = $conn->Procedimiento("dbo.PA_InsertarTablaTemporal");   
        }
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
	
	public function PA_ListarMesasxUbicacion($ubicacion)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Ubicacion", $ubicacion);
        $data = $conn->Procedimiento("dbo.PA_ListarMesasxUbicacion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPersonalVer()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarPersonalVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarCajaVer()
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $data = $conn->Procedimiento("dbo.PA_ListarCajaVer");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function ActualizaImpresionPedido($id, $valor)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $id);
        $conn->Parametro("@Valor", 'NO');
        $data = $conn->Procedimiento("dbo.PA_ActualizaEstadoPedidoImpresion");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->reiniciarArray();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $conn->Parametro("@cliente", $cliente);
        $conn->Parametro("@observaciones", $observaciones);
        $data = $conn->Procedimiento("dbo.PA_SOLO_CLIENTE");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ListarPermisosWeb_PorUsuario($codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@Codigo", $codigo);
        $data = $conn->Procedimiento("dbo.PA_ListarPermisosWeb_PorUsuario");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function PA_ObtenerEstadoSeEstaCobrando_PorCodigo($PED_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@PED_Codigo", $PED_Codigo);
        $data = $conn->Procedimiento("dbo.PA_ObtenerEstadoSeEstaCobrando_PorCodigo");
        $conn->Desconectar();
        return json_encode($data);
	}
}

$request = json_decode(file_get_contents('php://input'), true);

switch ($request['accion']) {
	case 'PA_REGISTRAR_PEDIDO':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_REGISTRAR_PEDIDO($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	case 'PA_MODIFICAR_PEDIDO':
	    try{
		    $pedido = $request['pedido'];
        	$app = new Operaciones();
        	echo $app->PA_MODIFICAR_PEDIDO($pedido);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
    case 'PA_ObtenerPersonal_PorCodigo':
		try{
        	$id = $request['per_codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerPersonal_PorCodigo($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarArticulos_Programacion_PorDescripcion':
		try{
        	$id = $request['descripcion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarArticulos_Programacion_PorDescripcion($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarPedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarDetallesDePedidoxCodigoMesa':
		try{
        	$id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarDetallesDePedidoxCodigoMesa($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_GeneraCodigoPedido':
		try{
        	$app = new Operaciones();
        	echo $app->PA_GeneraCodigoPedido();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_EliminarTablaTemporal_PorCodigoPedido':
		try{
		    $id = $request['codigo'];
        	$app = new Operaciones();
        	echo $app->PA_EliminarTablaTemporal_PorCodigoPedido($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_InsertarTablaTemporal':
		try{
		    $detalles = $request['detalles'];
        	$app = new Operaciones();
        	echo $app->PA_InsertarTablaTemporal($detalles);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarMesasxUbicacion':
		try{
		    $ubicacion = $request['ubicacion'];
        	$app = new Operaciones();
        	echo $app->PA_ListarMesasxUbicacion($ubicacion);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPersonalVer':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonalVer();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
    case 'PA_ListarCajaVer':
		try{
        	$app = new Operaciones();
        	echo $app->PA_ListarCajaVer();
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'ActualizaImpresionPedido':
		try{
		    $id = $request['codigo'];
		    $valor = $request['valor'];
        	$app = new Operaciones();
        	echo $app->ActualizaImpresionPedido($id, $valor);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_SOLO_CLIENTE':
		try{
		    $PED_Codigo = $request['PED_Codigo'];
		    $cliente = $request['cliente'];
		    $observaciones = $request['observaciones'];
        	$app = new Operaciones();
        	echo $app->PA_SOLO_CLIENTE($PED_Codigo, $cliente, $observaciones);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ListarPermisosWeb_PorUsuario':
		try{
		    $id = $request['Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPermisosWeb_PorUsuario($id);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
	case 'PA_ObtenerEstadoSeEstaCobrando_PorCodigo':
		try{
		    $PER_Codigo = $request['PER_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ObtenerEstadoSeEstaCobrando_PorCodigo($PER_Codigo);
	    }catch (Exception $ex){
	        echo json_encode($ex);
	    }
	    break;
}



